% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukb_dataset.R
\name{ukb_df_full_join}
\alias{ukb_df_full_join}
\title{Recursively join a list of UKB datasets}
\usage{
ukb_df_full_join(..., by = "eid")
}
\arguments{
\item{...}{Supply comma separated unquoted names of to-be-merged UKB datasets (created with \code{\link{ukb_df}}). Arguments are passed to \code{list}.}

\item{by}{Variable used to merge multiple dataframes (default = "eid").}
}
\description{
A thin wrapper around \code{purrr::reduce} and \code{dplyr::full_join} to merge multiple UKB datasets.
}
\details{
The function takes a comma separated list of unquoted datasets. By explicitly setting the join key to "eid" only (Default value of the \code{by} parameter), any additional variables common to any two tables will have ".x" and ".y" appended to their names. If you are satisfied the additional variables are identical to the original, the copies can be safely deleted. For example, if \code{setequal(my_ukb_data$var, my_ukb_data$var.x)} is \code{TRUE}, then my_ukb_data$var.x can be dropped. A \code{dlyr::full_join} is like the set operation union in that all abservation from all tables are included, i.e., all samples are included even if they are not included in all datasets.

NB. \code{ukb_df_full_join} will fail if any variable names are repeated **within** a single UKB dataset. This is unlikely to occur, however, \code{ukb_df} creates variable names by combining a snake_case descriptor with the variable's **index** and **array**. If an index_array combination is incorrectly repeated, this will result in a duplicated variable. If the join fails, you can use \code{\link{ukb_df_duplicated_name}} to find duplicated names. See \code{vignette(topic = "explore-ukb-data", package = "ukbtools")} for further details.
}
\examples{
\dontrun{
# If you have multiple UKB filesets, tidy then merge them.

ukb1234_data <- ukb_df("ukb1234")
ukb2345_data <- ukb_df("ukb2345")
ukb3456_data <- ukb_df("ukb3456")

my_ukb_data <- ukb_df_full_join(ukb1234_data, ukb2345_data, ukb3456_data)
}

}
\seealso{
\code{\link{ukb_df_duplicated_name}}
}
