% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukb_dataset.R
\name{ukb_df}
\alias{ukb_df}
\title{Reads a UK Biobank phenotype fileset and returns a single dataset.}
\usage{
ukb_df(fileset, path = ".", n_threads = "dt", data.pos = 2)
}
\arguments{
\item{fileset}{The prefix for a UKB fileset, e.g., ukbxxxx (for ukbxxxx.tab, ukbxxxx.r, ukbxxxx.html)}

\item{path}{The path to the directory containing your UKB fileset. The default value is the current directory.}

\item{n_threads}{Either "max" (uses the number of cores, `parallel::detectCores()`), "dt" (default - uses the data.table default, `data.table::getDTthreads()`), or a numerical value (in which case n_threads is set to the supplied value, or `parallel::detectCores()` if it is smaller).}

\item{data.pos}{Locates the data in your .html file. The .html file is read into a list; the default value data.pos = 2 indicates the second item in the list. (The first item in the list is the title of the table). You will probably not need to change this value, but if the need arises you can open the .html file in a browser and identify where in the file the data is.}
}
\value{
A dataframe with variable names in snake_case (lowercase and separated by an underscore).
}
\description{
A UK Biobank \emph{fileset} includes a \emph{.tab} file containing the raw data with field codes instead of variable names, an \emph{.r} (\emph{sic}) file containing code to read raw data (inserts categorical variable levels and labels), and an \emph{.html} file containing tables mapping field code to variable name, and labels and levels for categorical variables.
}
\details{
The \strong{index} and \strong{array} from the UKB field code are preserved in the variable name, as two numbers separated by underscores at the end of the name e.g. \emph{variable_index_array}. \strong{index} refers the assessment instance (or visit). \strong{array} captures multiple answers to the same "question". See UKB documentation for detailed descriptions of \href{http://biobank.ctsu.ox.ac.uk/crystal/instance.cgi?id=2}{index} and \href{http://biobank.ctsu.ox.ac.uk/crystal/help.cgi?cd=array}{array}.
}
\examples{
\dontrun{
# Simply provide the stem of the UKB fileset.
# To read ukb1234.tab, ukb1234.r, ukb1234.html

my_ukb_data <- ukb_df("ukb1234")


If you have multiple UKB filesets, tidy then merge.

ukb1234_data <- ukb_df("ukb1234")
ukb2345_data <- ukb_df("ukb2345")
ukb3456_data <- ukb_df("ukb3456")

my_ukb_data <- plyr::join_all(
  list(ukb1234_data, ukb2345_data, ukb3456_data),
  by = "eid",
  type = "full"
)
}

}
\seealso{
\code{\link{ukb_df_field}}
}
