% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetics_qc.R
\name{ukb_gen_sqc_names}
\alias{ukb_gen_sqc_names}
\title{Sample QC column names}
\usage{
ukb_gen_sqc_names(data, col_names_only = FALSE)
}
\arguments{
\item{data}{The UKB ukb_sqc_v2.txt data as dataframe. (Not necessary if column names only are required)}

\item{col_names_only}{If \code{TRUE} returns a character vector of column names (\code{data} argument not required). Useful if you would like to supply as header when reading in your sample QC data. If \code{FALSE} (Default), returns the supplied dataframe with column names (Checks number of columns in supplied data. See Details.).}
}
\value{
A sample QC dataframe with column names, or a character vector of column names if \code{col_names_only = TRUE}.
}
\description{
The UKB sample QC file has no header on it.
}
\details{
From \href{https://biobank.ctsu.ox.ac.uk/crystal/refer.cgi?id=531}{UKB Resource 531}: There are currently 2 versions of this file (UKB ukb_sqc_v2.txt) in circulation. The newer version is described below and contains column headers on the first row. The older (deprecated) version lacks the column headers and has two additional Affymetrix internal values prefixing the columns listed below.
}
