% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_data}
\alias{get_data}
\title{Get Data}
\usage{
get_data(
  theme = NULL,
  sub_theme = NULL,
  topic = NULL,
  geography_type = NULL,
  geography = NULL,
  metric = NULL
)
}
\arguments{
\item{theme}{the largest overall topical subgroup of data. For
example \code{infectious_disease}.}

\item{sub_theme}{a topical subgroup associated with the parent theme.
For example \code{respiratory}.}

\item{topic}{categorical subgroup associated with the selected
theme and sub_theme. For example, \code{COVID-19}.}

\item{geography_type}{the overarching area type for the intended geography.
For example \code{Nation}.}

\item{geography}{the selected area under the \code{geography_type}.
For example \code{England}.}

\item{metric}{the type of data being selected.
For example \code{COVID-19_testing_PCRcountByDay}.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{           data.frame containing the query results
}\if{html}{\out{</div>}}
}
\description{
Iteratively runs \code{\link{get_paginated_data}} to download all results and
combine them into a \code{data.frame}.
}
\details{
For further information on the UKHSA dashboard API please visit
the \href{https://ukhsa-dashboard.data.gov.uk/access-our-data}{API documentation}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{          If any input argument is left NULL or invalid, a list of possible values for that parameter is
                   returned.
}\if{html}{\out{</div>}}
}
\examples{
data <- get_data(
          theme = "infectious_disease",
          sub_theme = "respiratory",
          topic = "COVID-19",
          geography_type = "Nation",
          geography = "England",
          metric = "COVID-19_cases_casesByDay"
          )
}
