% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specific-crime-outcome.R
\name{ukc_specific_outcome}
\alias{ukc_specific_outcome}
\title{Outcomes for a specific crime}
\usage{
ukc_specific_outcome(persistent_id)
}
\arguments{
\item{persistent_id}{The 64 character string that is the unique ID of a
particular crime.}
}
\value{
Either a tibble with basic details of a crime, or a list with
basic details and outcomes (if available).
}
\description{
Returns the outcomes (case history) for a specified crime.
The ID of a crime is a 64-character string, named \code{persistent_id} and
returned by other methods.
}
\examples{
\donttest{
no_location <- ukc_crime_no_location(force = "city-of-london")

crime_id <- no_location$persistent_id[[1]]

outcome <- ukc_specific_outcome(crime_id)
}

}
