% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ulrb_clustering.R
\name{plot_ulrb_clustering}
\alias{plot_ulrb_clustering}
\title{Plot Rank Abundance Curve of classification results}
\usage{
plot_ulrb_clustering(
  data,
  sample_id = NULL,
  taxa_col,
  plot_all = FALSE,
  samples_col = "Sample",
  classification_col = "Classification",
  abundance_col = "Abundance",
  log_scaled = FALSE,
  colors = c("#009E73", "#F0E442", "#CC79A7"),
  ...
)
}
\arguments{
\item{data}{a data.frame with, at least, the classification, abundance and sample information for each phylogenetic unit.}

\item{sample_id}{string with name of selected sample.}

\item{taxa_col}{string with name of column with phylogenetic units. Usually OTU or ASV.}

\item{plot_all}{If TRUE, will make a plot for all samples with mean and standard deviation. If FALSE (default), then the plot will illustrate a single sample, that you have to specifiy in sample_id argument.}

\item{samples_col}{name of column with sample ID's.}

\item{classification_col}{string with name of column with classification for each row. Default value is "Classification".}

\item{abundance_col}{string with name of column with abundance values. Default is "Abundance".}

\item{log_scaled}{if TRUE then abundance scores will be shown in Log10 scale. Default to FALSE.}

\item{colors}{vector with colors. Should have the same lenght as the number of classifications.}

\item{...}{other arguments.}
}
\value{
A ggplot object with clustering results from \code{\link[=define_rb]{define_rb()}}.
}
\description{
Plots the clustering results from \code{\link[=define_rb]{define_rb()}}.
}
\details{
This works as a sanity check of the results obtained by the unsupervised learning method used
to classify species. This is specially important if you used an automatic number of clusters.

The function works for either a single sample (that you specify with sample_id argument), or
it can apply a centrality metric for species across all your samples (plot_all = TRUE).
}
\examples{
classified_species <- define_rb(nice_tidy)

# Standard plot for a single sample
plot_ulrb_clustering(classified_species,
                       sample_id = "ERR2044669",
                       taxa_col = "OTU",
                       abundance_col = "Abundance")
# All samples in a dataset
plot_ulrb_clustering(classified_species,
          taxa_col = "OTU",
          abundance_col = "Abundance",
          plot_all = TRUE)

# All samples with a log scale
plot_ulrb_clustering(classified_species,
          taxa_col = "OTU",
          abundance_col = "Abundance",
          plot_all = TRUE,
          log_scaled = TRUE)

}
\seealso{
\code{\link[=define_rb]{define_rb()}}, \code{\link[=plot_ulrb]{plot_ulrb()}}, \code{\link[=plot_ulrb_silhouette]{plot_ulrb_silhouette()}}
}
