% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotCP}
\alias{plot.MxModel.CP}
\alias{umxPlotCP}
\title{umxPlotCP}
\usage{
umxPlotCP(x = NA, dotFilename = "name", digits = 2, showMeans = FALSE,
  std = TRUE, ...)
}
\arguments{
\item{x}{The Common Pathway \code{\link{mxModel}} to display graphically}

\item{dotFilename}{The name of the file that is created (use "name" to create the file using the model's name parameter)}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{showMeans}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{...}{Optional additional parameters}
}
\value{
- Optionally return the dot code
}
\description{
Draw a graphical figure for a Common Pathway model
}
\examples{
\dontrun{
umxPlotCP(model)
plot(model) # works fine!
umxPlotCP(model, dotFilename = "MyPreferredName.dot")
}
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.
}

