% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_names}
\alias{umx_names}
\title{umx_names}
\usage{
umx_names(df, pattern = ".*", replacement = NULL, ignore.case = TRUE,
  perl = FALSE, value = TRUE, fixed = FALSE, useBytes = FALSE,
  invert = FALSE)
}
\arguments{
\item{df}{dataframe from which to get names.}

\item{pattern}{used to filter-out only some names (supports wild card/regular expressions)}

\item{replacement}{if not NULL, replaces the found string.}

\item{ignore.case}{default = TRUE (opposite default to grep)}

\item{perl}{= FALSE}

\item{value}{= default = TRUE (opposite default to grep)}

\item{fixed}{= FALSE}

\item{useBytes}{= FALSE}

\item{invert}{= FALSE}
}
\value{
- vector of matches
}
\description{
Convenient equivalent of grep("fa[rl].*", names(df), value = TRUE, ignore.case = TRUE)
Can handle dataframe (uses names), model (uses parameter names), or a vector of strings.
}
\examples{
umx_names(mtcars, "mpg") # just "mpg" matches
umx_names(mtcars, "^d") # "disp", drat
umx_names(mtcars, "r[ab]") # "drat", "carb"
umx_names(mtcars, "mpg", replacement = "hello") # "mpg" replaced with "hello"

# =======================================
# = Examples using built-in GFF dataset =
# =======================================

umx_names(GFF, "T_1$") # twin 1
# "zyg" "sex1" "age_T1" "gff_T1" "fc_T1" "qol_T1" "hap_T1"...
umx_names(GFF, "2$") # names ending in 2
umx_names(GFF, "[^12bs]$") # doesn't end in `1`, `2`, `b`, or `s`
# "zyg_6grp" "zyg_2grp" "divorce"
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{grep}}, \code{\link{sub}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_parameters}}, \code{\link{umx_print}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
