% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxSimplex.R
\name{umxSummarySimplex}
\alias{umxSummarySimplex}
\alias{umxSummary.MxModelSimplex}
\title{Shows a compact, publication-style, summary of a Simplex model.}
\usage{
umxSummarySimplex(model, digits = 2, file = getOption("umx_auto_plot"),
  comparison = NULL, std = TRUE, showRg = FALSE, CIs = TRUE,
  report = c("markdown", "html"), returnStd = FALSE, extended = FALSE,
  zero.print = ".", ...)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = no plot.}

\item{comparison}{you can run mxCompare on a comparison model (default = NULL)}

\item{std}{Whether to standardize the output (default = TRUE)}

\item{showRg}{(T/F) Whether to show the genetic correlations (default = FALSE)}

\item{CIs}{Whether to show Confidence intervals if they exist (default = TRUE)}

\item{report}{If "html", then open an html table of the results (default = 'markdown')}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (default = FALSE)}

\item{zero.print}{How to show zeros (default = ".")}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a fitted Simplex model returned by \code{\link{umxSimplex}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. the report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for RAM models summary here: \code{\link{umxSummary.MxModel}}.

View documentation on the ACE model subclass here: \code{\link{umxSummary.MxModelACE}}.

View documentation on the IP model subclass here: \code{\link{umxSummary.MxModelIP}}.

View documentation on the CP model subclass here: \code{\link{umxSummary.MxModelCP}}.

View documentation on the GxE model subclass here: \code{\link{umxSummary.MxModelGxE}}.
}
\examples{
data(iqdat)
nTimePoints = 4 # Number of time points
baseVarNames = paste0("IQ_age", 1:nTimePoints)
# IQ_age + 1:4 + "_T" 1:2

# Select Data
mzData <- subset(iqdat, zygosity == "MZ")
dzData <- subset(iqdat, zygosity == "DZ")
m1 = umxSimplex(selDVs = baseVarNames, sep = "_T", dzData = dzData, mzData = mzData)
umxSummary(m1)
\dontrun{
umxSummary(m1, file = NA);
umxSummary(m1, file = "name", std = TRUE)
stdFit = umxSummary(m1, returnStd = TRUE)
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxSimplex}}

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_biv}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxSexLim}}, \code{\link{umxSimplex}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE_biv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
