% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_scale}
\alias{umx_scale}
\title{Scale data columns, skipping non-scalable columns}
\usage{
umx_scale(df, varsToScale = NULL, coerce = FALSE, attr = FALSE,
  verbose = FALSE)
}
\arguments{
\item{df}{A dataframe to scale (or a numeric vector)}

\item{varsToScale}{(leave blank to scale all)}

\item{coerce}{Whether to coerce non-numerics to numeric (Defaults to FALSE.}

\item{attr}{to strip off the attributes scale creates (FALSE by default)}

\item{verbose}{Whether to report which columns were scaled (default FALSE)}
}
\value{
\itemize{
\item new dataframe with scaled variables
}
}
\description{
\code{umx_scale} applies scale to the columns of a data.frame. By default it scales all numeric columns,
and is smart enough to skip non-scalable columns (strings, factors, etc.).

You can also select which columns to convert.
This is useful when you want to avoid numeric columns which are actually factors.

\emph{note}: By default, the attributes which scale adds ("scaled:center" and
"scaled:scale" removed to leave nice numeric columns. Set \code{attr= TRUE} to preserve these.
}
\examples{
data(twinData) 
df = umx_scale(twinData, varsToScale = c("wt1", "wt2"))
df = umx_scale(twinData,  attr= TRUE)
plot(wt1 ~ wt2, data = df)
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
umx_scale_wide_twin_data scale

Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}},
  \code{\link{qm}}, \code{\link{umxBrownie}},
  \code{\link{umxFactor}}, \code{\link{umxVersion}},
  \code{\link{umx_array_shift}},
  \code{\link{umx_cell_is_on}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_find_object}},
  \code{\link{umx_graphviz_rank}}, \code{\link{umx_make}},
  \code{\link{umx_mat2dot}}, \code{\link{umx_msg}},
  \code{\link{umx_open_CRAN_page}}, \code{\link{umx_pad}},
  \code{\link{umx_pb_note}}, \code{\link{umx_print}},
  \code{\link{umx_score_scale}}, \code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
