% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arizona.R
\docType{data}
\name{asu_2}
\alias{asu_2}
\title{Secondary colors of the Arizona State University, USA}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\href{https://brandguide.asu.edu/brand-elements/design/color}{ASU's brand guide}.
}
\usage{
asu_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{asu_2} provides the seven secondary colors
of the \href{https://www.asu.edu}{Arizona State University}, USA.
}
\details{
The 7 secondary colors are
\code{"asu_green"} (defined as HEX #78BE20),
\code{"asu_blue"} (defined as HEX #00A3E0),
\code{"asu_orange"} (defined as HEX #FF7F32),
\code{"asu_gray"} (defined as HEX #747474), 
\code{"asu_copper"} (defined as HEX #Af674B), 
\code{"asu_turquoise"} (defined as HEX #4AB7C4), and 
\code{"asu_pink"} (defined as HEX #E74973). 

\code{asu_2} uses the HEX color definitions.
}
\examples{
asu_2
unikn::seecol(asu_2, main = "Arizona State University 2") # view color palette

}
\seealso{
\code{\link{asu_1}} for ASU's primary colors;
\code{\link{asu_3}} for ASU's grayscale colors;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-13.
}
\concept{university color palettes.}
\keyword{datasets}
