% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Duke.R
\docType{data}
\name{duke_2}
\alias{duke_2}
\title{Secondary colors of Duke University, USA}
\format{
An object of class \code{character} of length 18.
}
\source{
Color definitions are based on the
\href{https://brand.duke.edu/colors/}{Color manual}.
}
\usage{
duke_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{duke_2} provides the 18 secondary colors
of the \href{https://duke.edu}{Duke University}, USA.
}
\details{
The colors in Duke’s extended palette are intended for use as secondary and tertiary colors in design projects.
They were selected to complement Duke Navy Blue and should be used for a range of elements including graphic accents,
typography, backgrounds, call-to-action buttons and more.
These colors are
\code{"copper"} (defined as CMYK 0/76/100/0, RGB 200/78/0, HEX #C84E00),
\code{"persimmon"} (defined as CMYK 0/45/95/0, RGB 232/153/35, HEX #E89923),
\code{"dandelion"} (defined as CMYK 0/8/70/0, RGB 255/217/96, HEX #FFD960),
\code{"piedmont"} (defined as CMYK 54/0/100/0, RGB 161/183/13, HEX #A1B70D),
\code{"eno"} (defined as CMYK 81/0/39/0, RGB 51/152/152, HEX #339898),
\code{"magnolia"} (defined as CMYK 96/16/42/57, RGB 29/99/99, HEX #1D6363),
\code{"prussian_blue"} (defined as CMYK 100/45/0/45, RGB 0/85/135, HEX #005587),
\code{"shale_blue"} (defined as CMYK 100/0/1/3, RGB 5/119/177, HEX #0577B1),
\code{"ironweed"} (defined as CMYK 35/95/0/0, RGB 153/51/153, HEX #993399),
\code{"hatteras"} (defined as CMYK 10/2/0/0, RGB 226/230/237, HEX #E2E6ED),
\code{"whisper_gray"} (defined as CMYK 4/2/4/8, RGB 243/242/241, HEX #F3F2F1),
\code{"ginger_beer"} (defined as CMYK 0/2/15/0, RGB 252/247/229, HEX #FCF7E5),
\code{"dogwood"} (defined as CMYK 10/18/25/32, RGB 152/134/117, HEX #988675),
\code{"shackleford"} (defined as CMYK 3/4/14/8, RGB 218/208/198, HEX #DAD0C6),
\code{"cast_iron"} (defined as CMYK 67/44/67/95, RGB 38/38/38, HEX #262626),
\code{"graphite"} (defined as CMYK 40/30/20/66, RGB 102/102/102, HEX #666666),
\code{"granite"} (defined as CMYK 13/8/11/26, RGB 181/181/181, HEX #B5B5B5), and
\code{"limestone"} (defined as CMYK 5/3/5/11, RGB 229/229/229, HEX #E5E5E5).
}
\examples{
duke_2
unikn::seecol(duke_2, main = "Secondary colors Duke University") # view color palette

}
\seealso{
\code{\link{duke_1}} for primary colors of Duke University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCSD_1_core}},
\code{\link{UCSD_2_accent}},
\code{\link{UCSD_3_neutral}},
\code{\link{asu_1}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{birmingham_1}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu_1}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{carleton_1}},
\code{\link{chicago_1}},
\code{\link{chicago_2}},
\code{\link{columbia}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{duke_1}},
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh_1}},
\code{\link{eth_1}},
\code{\link{eth_2}},
\code{\link{eth_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{guelph}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{laval}},
\code{\link{limerick_1}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_2}},
\code{\link{mit_pal}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{mpg_pal}},
\code{\link{msu_pal}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ottawa_1}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{queens_1}},
\code{\link{queens_2}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{sfu_brand}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{toronto_1}},
\code{\link{trinity_1}},
\code{\link{ubc_1}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_primary}},
\code{\link{ucalgary_secondary}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uci_1}},
\code{\link{uflorida_1}},
\code{\link{umass_2}},
\code{\link{umass_brand}},
\code{\link{umass_neutrals}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg_1}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_manchester_1}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_2_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_3}},
\code{\link{waikato}},
\code{\link{western_uni_1}},
\code{\link{yale_1}},
\code{\link{yeshiva}},
\code{\link{york1}},
\code{\link{york2}}
}
\author{
\strong{unicol}, 2023-06-16.
}
\concept{university color palettes}
\keyword{datasets}
