% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irvine.R
\docType{data}
\name{uci_4}
\alias{uci_4}
\title{Neutral colors of the University of California, Irvine, USA}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\href{https://brand.uci.edu/master-branding/color-palette/}{UCI's brand guide}.
}
\usage{
uci_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uci_4} provides the 5 neutral colors
of the \href{https://www.uci.edu}{University of California Health, Irvine}, USA.
}
\details{
The 5 neutral colors are 
\code{"brick_red"} (defined as HEX #981e32),
\code{"purple"} (defined as HEX #631d76),
\code{"teal_blue"} (defined as HEX #0083b3),
\code{"green"} (defined as HEX #3f9c35), and 
\code{"dark_blue"} (defined as HEX #1b3d6d).

\code{uci_4} uses the HEX color definitions.
}
\examples{
uci_4
unikn::seecol(uci_4, main = "U of California, Irvine (4: neutral)") # view color palette

}
\seealso{
\code{\link{uci_1}} for primary colors of UC Irvine;
\code{\link{uci_2}} for secondary colors of UC Irvine;
\code{\link{uci_3}} for tertiary colors of UC Irvine;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.
}
\author{
\strong{unicol}, 2023-07-13.
}
\keyword{datasets}
