% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Minnesota_Twin_Cities.R
\docType{data}
\name{minnesotatwin_2}
\alias{minnesotatwin_2}
\title{Secondary colors of the University of Minnesota Twin Cities, USA}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on the
\href{https://university-relations.umn.edu/resources/colors-and-type}{UMN website}.
}
\usage{
minnesotatwin_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{minnesotatwin_2} provides the 8 secondary colors
of the \href{https://twin-cities.umn.edu/}{University of Minnesota Twin Cities}, USA.
}
\details{
The 8 secondary colors are
\code{"minnesotatwin_dark-marron"} (defined as HEX #5B0013),
\code{"minnesotatwin_dark_gold"} (defined as HEX #FFB71E),
\code{"minnesotatwin_darker_gray"} (defined as HEX #333333),
\code{"minnesotatwin_medium_grey"} (defined as HEX #777677),
\code{"minnesotatwin_light_maroon"} (defined as HEX #900021),
\code{"minnesotatwin_light_gold"} (defined as HEX #FFDE7A),
\code{"minnesotatwin_dark_grey"} (defined as HEX #5A5A5A), and
\code{"minnesotatwin_light_grey"} (defined as HEX #D5D6D2).

\code{minnesotatwin_2} uses the HEX color definitions.
}
\examples{
minnesotatwin_2
unikn::seecol(minnesotatwin_2, 
              main = "University of Minnesotatwin Twin Cities") # view color palette

}
\seealso{
\code{\link{minnesotatwin_1}} for the primary colors of UMN;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-07-01.
}
\concept{U.S. university color palettes}
\keyword{datasets}
