% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Maynooth.R
\docType{data}
\name{maynooth}
\alias{maynooth}
\title{Colours of Maynooth University, Ireland}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on 
\href{https://www.maynoothuniversity.ie}{MU}'s Brand identity guide (2021, PDF, p. 25).
}
\usage{
maynooth
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{maynooth} provides the four logo colours 
of the \href{https://www.maynoothuniversity.ie}{National University of Ireland Maynooth}, IE.
}
\details{
The 4 logo colours are
\code{PANTONE 294}, defined as CMYK 100.65.0.31, RGB 0.55.113, or HEX "#003771", 
\code{PANTONE 130}, defined as CMYK 0.30.100.6, RGB 240.171.0, or HEX "#F0AB00", 
\code{PANTONE 3145}, defined as CMYK 100.0.30.31, RGB 0.103.120, or HEX "#006778", and 
\code{PANTONE 202}, defined as CMYK 10.100.61.50, RGB 130.35.39, or HEX "#822327".

\code{maynooth} uses the HEX color definitions.


A set of colours have been selected for the \href{https://www.maynoothuniversity.ie}{Maynooth University} logo 
and must be used when reproducing the logo in colour.

These colours and tints of these colours may be used on \href{https://www.maynoothuniversity.ie}{Maynooth University} applications.
}
\examples{
maynooth
unikn::seecol(maynooth, main = "The colours of Maynooth University, IE")  # view palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2023-09-09.
}
\concept{Irish university color palettes}
\keyword{datasets}
