# uniset 0.3.0

## New
* Changed the way uniset is communicating with the target package so that the
call to `attach()`is not required any more in the `.onLoad()` function of the
target package. This is due to the fact that a call to `attach()` is throwing
a note when running R-CMD-CHECK. And though the author believes the call to 
attach() was perfectly justified and correct in this case, it still made it
impossible to get through the required checks.
	* For Developers: Please use `uniset_getFiles()` to obtain a fresh version
	of the files required in the target package and modify your functions
	accordingly. Please observe that the code generated by `uniset` for the 
	`.onLoad()` function is not required any more.
* Introduced a strategy to be able to run tests in the target package: By
assigning a variable to `.GlobalEnv`in the test-code
`assign("get_settings_from_XXX_package_root", TRUE, pos=.GlobalEnv)`,
(with `XXX`being the name of the package)
the settings file from the package root instead of the user-defined settings
file will be sourced.

## Improved
* Website now made with pkgdown





# uniset 0.2.1
Second submission to CRAN
submitted on 2021-10-12

## New
* User-space is not written into any more by default. Now there is a dedicated setup-function to be called by the user. Only this setup-function does write into user space according to the path provided by the user. System-setup and system-check is now completely separated.
* .GlobalEnv is not written into any more. Instead, a separate object is created on the search path where all required environments reside. 
* Have an additional file 'uniset_functions.R' generated in the process of preparing the target package, containing custom-tailored functions to be used in functions defined in the target package. 


## IMPROVED:
* Manuals (all return values now explained in detail); readme.md; description.
* Examples: Only those examples that really can not be run stay wrapped in  \dontrun{}.
* Various other details.



# uniset 0.1.1

Initial submission to CRAN

Initial submission on 2021-10-01.