% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchains.R
\name{nchains}
\alias{nchains}
\title{Number of Chains}
\usage{
nchains(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
An integer scalar of the number of chains.
}
\description{
Gets the number of chains
of an MCMC object.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

nchains(nlist(x = 1:2))
nlists <- nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7)))
nchains(nlists)
nchains(split_chains(nlists))
\dontshow{\}) # examplesIf}
}
\seealso{
Other MCMC dimensions: 
\code{\link{niters}()},
\code{\link{npars}()},
\code{\link{nsams}()},
\code{\link{nsims}()},
\code{\link{nterms}()}
}
\concept{MCMC dimensions}
