% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlimit.R
\name{rlimit}
\alias{rlimit}
\alias{rlimit_as}
\alias{rlimit_core}
\alias{rlimit_cpu}
\alias{rlimit_data}
\alias{rlimit_fsize}
\alias{rlimit_memlock}
\alias{rlimit_nofile}
\alias{rlimit_nproc}
\alias{rlimit_stack}
\title{Resource Limits}
\usage{
rlimit_as(cur = NULL, max = NULL)

rlimit_core(cur = NULL, max = NULL)

rlimit_cpu(cur = NULL, max = NULL)

rlimit_data(cur = NULL, max = NULL)

rlimit_fsize(cur = NULL, max = NULL)

rlimit_memlock(cur = NULL, max = NULL)

rlimit_nofile(cur = NULL, max = NULL)

rlimit_nproc(cur = NULL, max = NULL)

rlimit_stack(cur = NULL, max = NULL)
}
\arguments{
\item{cur}{set the current (soft) limit for this resource. See details.}

\item{max}{set the max (hard) limit for this resource. See details.}
}
\description{
Get and set process resource limits. Each function returns the current limits, and
can optionally update the limit by passing argument values.
}
\details{
Each resource has an associated soft and  hard limit. The soft limit is the value
that the kernel enforces for the corresponding resource.  The hard limit acts as a
ceiling for the soft limit: an unprivileged process may set only its soft limit to
a value in the range from 0 up to the hard limit, and (irreversibly) lower its hard
limit.

Definitons from the \href{http://man7.org/linux/man-pages/man2/setrlimit.2.html}{Linux manual page}
are as follows:
\itemize{
\item \code{RLIMIT_AS} : the maximum size of the process's virtual memory (address space) in bytes.
\item \code{RLIMIT_CORE} : the maximum size of a core file that the process may dump.
\item \code{RLIMIT_CPU} : a limit in seconds on the amount of CPU time (\strong{not} elapsed time) that
the process may consume. When the process reaches the soft limit, it is sent a \code{SIGXCPU} signal.
\item \code{RLIMIT_DATA} : the maximum size of the process's data segment (initialized data, uninitialized
data, and heap).
\item \code{RLIMIT_FSIZE} : the maximum size of files that the process may create. Attempts to extend a
file beyond this limit result in delivery of a SIGXFSZ signal.
\item \code{RLIMIT_MEMLOCK} : the maximum number of bytes of memory that may be locked into RAM.
\item \code{RLIMIT_NOFILE} : a value one greater than the maximum file descriptor number that can be opened
by this process.
\item \code{RLIMIT_NPROC} : the maximum number of processes that can be created for the real user ID of the
calling process.  Upon encountering this limit, fork fails with the error EAGAIN. Not enforced for
root user.
\item \code{RLIMIT_STACK} : the maximum size of the process stack, in bytes.
}

Note that the support for enforcing limits very widely by system. In particular
\code{RLIMIT_AS} has a different meaning depending on how memory allocation is managed
by the operating system (and doesn't work at all on MacOS).
}
\examples{
# Get current limit
rlimit_as()

# Set a soft limit
rlimit_as(1e9)

# Set a hard limit
rlimit_as(max = 1e10)
}
\references{
\href{http://man7.org/linux/man-pages/man2/setrlimit.2.html}{GETRLIMIT(2)}
}
