% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unm_glm.R
\name{unm_glm}
\alias{unm_glm}
\alias{jags_code}
\alias{print.unm_int}
\alias{coef.unm_int}
\title{Fitting Multi-Staged Bayesian Regression Model with Unmeasured Confounders}
\usage{
unm_glm(
  form1,
  form2 = NULL,
  form3 = NULL,
  family1 = binomial(),
  family2 = NULL,
  family3 = NULL,
  data,
  n.iter = 2000,
  n.adapt = 1000,
  thin = 1,
  n.chains = 4,
  filename = tempfile(fileext = ".jags"),
  quiet = getOption("unm_quiet"),
  progress.bar = getOption("unm_progress.bar"),
  code_only = FALSE,
  priors,
  response_nuisance_priors,
  response_params_to_track,
  confounder1_nuisance_priors,
  confounder1_params_to_track,
  confounder2_nuisance_priors,
  confounder2_params_to_track,
  ...
)

jags_code(mod)

\method{print}{unm_int}(x, digits = 3, ..., print_call = getOption("unm_print_call"))

\method{coef}{unm_int}(object, ...)
}
\arguments{
\item{form1}{The formula specification for the response model (stage I)}

\item{form2}{The formula specification for the first unmeasured confounder
model (stage II)}

\item{form3}{The formula specification for the second unmeasured confounder
model (stage III)}

\item{family1, family2, family3}{The family object, communicating the types of
models to be used for response (\code{form1}) and unmeasured confounder (\verb{form2, form3}) models. See \code{\link[stats:family]{stats::family()}} for details}

\item{data}{The dataset containing all variables (this function currently
only supports a single dataset containing internally validated data)}

\item{n.iter}{\code{n.iter} argument of \code{\link[rjags:coda.samples]{rjags::coda.samples()}}}

\item{n.adapt}{\code{n.adapt} argument of \code{\link[rjags:jags.model]{rjags::jags.model()}}}

\item{thin}{\code{thin} argument of \code{\link[rjags:coda.samples]{rjags::coda.samples()}}}

\item{n.chains}{\code{n.chains} argument of \code{\link[rjags:jags.model]{rjags::jags.model()}}}

\item{filename}{File name where to store jags code}

\item{quiet}{The \code{quiet} parameter of \code{\link[rjags:jags.model]{rjags::jags.model()}}. Defaults to
\code{TRUE}, but you can change it on a per-session basis with
\code{options(unm_quiet = FALSE)}.}

\item{progress.bar}{The \code{progress.bar} parameter of \code{\link[rjags:update]{rjags::update.jags()}}.
Defaults to \code{"none"}, but you can change it on a per-session basis with
\code{options(unm_progress.bar = "text")}.}

\item{code_only}{Should only the code be created?}

\item{priors}{Custom priors to use on regression coefficients, see examples.}

\item{response_nuisance_priors, confounder1_nuisance_priors, confounder2_nuisance_priors}{JAGS code for the nuisance priors on parameters in a JAGS model (see
examples)}

\item{response_params_to_track, confounder1_params_to_track, confounder2_params_to_track}{Additional parameters to track when nuisance parameter priors are used (see
examples)}

\item{...}{Additional arguments to pass into \code{\link[rjags:jags.model]{rjags::jags.model()}}, such as
\code{inits}}

\item{mod}{The output of \code{\link[=unm_glm]{unm_glm()}}}

\item{x}{Object to be printed}

\item{digits}{Number of digits to round to; defaults to 3}

\item{print_call}{Should the call be printed? Defaults to \code{TRUE}, but can be
turned off with \code{options("unm_print_call" = FALSE)}}

\item{object}{Model object for which the coefficients are desired}
}
\value{
(Invisibly) The output of \code{\link[rjags:coda.samples]{rjags::coda.samples()}}, an object of class
\code{mcmc.list}, along with attributes \code{code} containing the jags code used and
\code{file} containing the filename of the jags code.
}
\description{
\code{\link[=unm_glm]{unm_glm()}} fits a multi-staged Bayesian regression model that accounts for
unmeasured confounders. Users can input model information into \code{\link[=unm_glm]{unm_glm()}} in
a similar manner as they would for the standard \code{\link[stats:glm]{stats::glm()}} function,
providing arguments like \code{formula}, \code{family}, and \code{data}. Results are stored
as MCMC iterations.
}
\examples{

\donttest{

# ~~ One Unmeasured Confounder Examples (II-Stage Model) ~~


# normal response, normal confounder model with internally validated data
(df <- runm(20, response = "norm"))

(unm_mod <- unm_glm(
  y ~ x + z1 + z2 + z3 + u1,  family1 = gaussian(),
  u1 ~ x + z1 + z2 + z3,      family2 = gaussian(),
  data = df
))

(unm_mod <- unm_glm(
  y ~ .,      family1 = gaussian(),
  u1 ~ . - y, family2 = gaussian(),
  data = df
))
glm(y ~ x + z1 + z2 + z3, data = df)
coef(unm_mod)

jags_code(unm_mod)
unm_glm(
  y ~ .,
  u1 ~ . - y,
  family1 = gaussian(),
  family2 = gaussian(),
  data = df, code_only = TRUE
)



}

}
\seealso{
\code{\link[=runm]{runm()}}, \code{\link[rjags:dic.samples]{rjags::dic.samples()}}
}
