% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cond_maha}
\alias{cond_maha}
\title{Calculate the conditional Mahalanobis distance for any variables.}
\usage{
cond_maha(
  data,
  R,
  v_dep,
  v_ind = NULL,
  v_ind_composites = NULL,
  mu = 0,
  sigma = 1,
  use_sample_stats = FALSE,
  label = NA
)
}
\arguments{
\item{data}{Data.frame with the independent and dependent variables.
Unless mu and sigma are specified, data are assumed to be z-scores.}

\item{R}{Correlation among all variables.}

\item{v_dep}{Vector of names of the dependent variables in your profile.}

\item{v_ind}{Vector of names of independent variables you would like to
control for.}

\item{v_ind_composites}{Vector of names of independent variables that are
composites of dependent variables}

\item{mu}{A vector of means. A single value means that all variables have
the same mean.}

\item{sigma}{A vector of standard deviations. A single value means that
all variables have the same standard deviation}

\item{use_sample_stats}{If TRUE, estimate R, mu, and sigma from data.
Only complete cases are used (i.e., no missing values in v_dep, v_ind,
v_ind_composites).}

\item{label}{optional tag for labeling output}
}
\value{
a list with the conditional Mahalanobis distance
\itemize{
\item{\code{dCM} = Conditional Mahalanobis distance}
\item{\code{dCM_df} = Degrees of freedom for the conditional Mahalanobis distance}
\item{\code{dCM_p} = A proportion that indicates how unusual this profile is compared to profiles with the same independent variable values. For example, if \code{dCM_p} = 0.88, this profile is more unusual than 88 percent of profiles after controlling for the independent variables.}
\item{\code{dM_dep} = Mahalanobis distance of just the dependent variables}
\item{\code{dM_dep_df} = Degrees of freedom for the Mahalanobis distance of the dependent variables}
\item{\code{dM_dep_p} = Proportion associated with the Mahalanobis distance of the dependent variables}
\item{\code{dM_ind} = Mahalanobis distance of just the independent variables}
\item{\code{dM_ind_df} = Degrees of freedom for the Mahalanobis distance of the independent variables}
\item{\code{dM_ind_p} = Proportion associated with the Mahalanobis distance of the independent variables}
\item{\code{v_dep} = Dependent variable names}
\item{\code{v_ind} = Independent variable names}
\item{\code{v_ind_singular} = Independent variables that can be perfectly predicted from the dependent variables (e.g., composite scores)}
\item{\code{v_ind_nonsingular} = Independent variables that are not perfectly predicted from the dependent variables}
\item{\code{data} = data used in the calculations}
\item{\code{d_ind} = independent variable data}
\item{\code{d_inp_p} = Assuming normality, cumulative distribution function of the independent variables}
\item{\code{d_dep} = dependent variable data}
\item{\code{d_dep_predicted} = predicted values of the dependent variables}
\item{\code{d_dep_deviations = d_dep - d_dep_predicted} (i.e., residuals of the dependent variables)}
\item{\code{d_dep_residuals_z} = standardized residuals of the dependent variables}
\item{\code{d_dep_cp} = conditional proportions associated with standardized residuals}
\item{\code{d_dep_p} = Assuming normality, cumulative distribution function of the dependent variables}
\item{\code{R2} = Proportion of variance in each dependent variable explained by the independent variables}
\item{\code{SEE} = Standard error of the estimate for each dependent variable}
\item{\code{ConditionalCovariance} = Covariance matrix of the dependent variables after controlling for the independent variables}
\item{\code{distance_reduction = 1 - (dCM / dM_dep)} (Degree to which the independent variables decrease the Mahalanobis distance of the dependent variables. Negative reductions mean that the profile is more unusual after controlling for the independent variables. Returns 0 if \code{dM_dep} is 0.)}
\item{\code{variability_reduction = 1 - sum((X_dep - predicted_dep) ^ 2) / sum((X_dep - mu_dep) ^ 2)} (Degree to which the independent variables decrease the variability the dependent variables (\code{X_dep}). Negative reductions mean that the profile is more variable after controlling for the independent variables. Returns 0 if \code{X_dep == mu_dep})}
\item{\code{mu} = Variable means}
\item{\code{sigma} = Variable standard deviations}
\item{\code{d_person} = Data frame consisting of Mahalanobis distance data for each person}
\item{\code{d_variable} = Data frame consisting of variable characteristics}
\item{\code{label} = label slot}
}
}
\description{
Calculate the conditional Mahalanobis distance for any variables.
}
\examples{
library(unusualprofile)
library(simstandard)

m <- "
Gc =~ 0.85 * Gc1 + 0.68 * Gc2 + 0.8 * Gc3
Gf =~ 0.8 * Gf1 + 0.9 * Gf2 + 0.8 * Gf3
Gs =~ 0.7 * Gs1 + 0.8 * Gs2 + 0.8 * Gs3
Read =~ 0.66 * Read1 + 0.85 * Read2 + 0.91 * Read3
Math =~ 0.4 * Math1 + 0.9 * Math2 + 0.7 * Math3
Gc ~ 0.6 * Gf + 0.1 * Gs
Gf ~ 0.5 * Gs
Read ~ 0.4 * Gc + 0.1 * Gf
Math ~ 0.2 * Gc + 0.3 * Gf + 0.1 * Gs"
# Generate 10 cases
d_demo <- simstandard::sim_standardized(m = m, n = 10)

# Get model-implied correlation matrix
R_all <- simstandard::sim_standardized_matrices(m)$Correlations$R_all

cond_maha(data = d_demo,
          R = R_all,
          v_dep = c("Math", "Read"),
          v_ind = c("Gf", "Gs", "Gc"))
}
