% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{badges}
\alias{badges}
\alias{use_badge}
\alias{use_cran_badge}
\alias{use_bioc_badge}
\alias{use_lifecycle_badge}
\alias{use_binder_badge}
\alias{use_posit_cloud_badge}
\alias{use_rscloud_badge}
\title{README badges}
\usage{
use_badge(badge_name, href, src)

use_cran_badge()

use_bioc_badge()

use_lifecycle_badge(stage)

use_binder_badge(ref = git_default_branch(), urlpath = NULL)

use_posit_cloud_badge(url)

use_rscloud_badge(url)
}
\arguments{
\item{badge_name}{Badge name. Used in error message and alt text}

\item{href, src}{Badge link and image src}

\item{stage}{Stage of the package lifecycle. One of "experimental",
"stable", "superseded", or "deprecated".}

\item{ref}{A Git branch, tag, or SHA}

\item{urlpath}{An optional \code{urlpath} component to add to the link, e.g.
\code{"rstudio"} to open an RStudio IDE instead of a Jupyter notebook. See the
\href{https://mybinder.readthedocs.io/en/latest/howto/user_interface.html}{binder documentation}
for additional examples.}

\item{url}{A link to an existing \href{https://posit.cloud}{Posit Cloud}
project. See the \href{https://posit.cloud/learn/guide#project-settings-access}{Posit Cloud documentation}
for details on how to set project access and obtain a project link.}
}
\description{
These helpers produce the markdown text you need in your README to include
badges that report information, such as the CRAN version or test coverage,
and link out to relevant external resources. To add badges automatically
ensure your badge block starts with a line containing only
\verb{<!-- badges: start -->} and ends with a line containing only
\verb{<!-- badges: end -->}.
}
\details{
\itemize{
\item \code{use_badge()}: a general helper used in all badge functions
\item \code{use_bioc_badge()}: badge indicates \href{https://bioconductor.org/developers/}{BioConductor build status}
\item \code{use_cran_badge()}: badge indicates what version of your package is
available on CRAN, powered by \url{https://www.r-pkg.org}
\item \code{use_lifecycle_badge()}: badge declares the developmental stage of a
package according to \url{https://lifecycle.r-lib.org/articles/stages.html}.
\item \code{use_binder_badge()}: badge indicates that your repository can be launched
in an executable environment on \url{https://mybinder.org/}
\item \code{use_posit_cloud_badge()}: badge indicates that your repository can be launched
in a \href{https://posit.cloud}{Posit Cloud} project
\item \code{use_rscloud_badge()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: Use
\code{\link[=use_posit_cloud_badge]{use_posit_cloud_badge()}} instead.
}
}
\examples{
\dontrun{
use_cran_badge()
use_lifecycle_badge("stable")
}
}
\seealso{
Functions that configure continuous integration, such as
\code{\link[=use_github_actions]{use_github_actions()}}, also create badges.
}
