% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd.R
\name{ustfd_response_meta_object}
\alias{ustfd_response_meta_object}
\title{Extract Metadata From Parsed API Response}
\usage{
ustfd_response_meta_object(response)
}
\arguments{
\item{response}{a parsed response returned by \code{\link[=ustfd_json_response]{ustfd_json_response()}}}
}
\value{
a list
}
\description{
\code{ustfd_response_meta_object()}  will return the meta object included in a
successful API response. The meta object is a list with the following items:
\itemize{
\item \code{count} - the number of records in the response
\item \code{labels} - a named list of labels for each field
\item \code{dataTypes} - a named list describing the data type for each field
\item \code{dataFormats} - a named list describing the data format for each field
\item \code{total-count} - the total number of records matching the query
\item \code{total-pages} - the total number of pages of records matching the query
}
}
\examples{
\dontrun{
library(ustfd)
query <- ustfd_query('/v1/accounting/dts/dts_table_4', sort =c('-record_date'))
response <- ustfd_request(query)
payload_table <- ustfd_response_payload(response)
payload_meta <- ustfd_response_meta_object(response)
}
}
\seealso{
Other ustfd_low_level: 
\code{\link{ustfd_json_response}()},
\code{\link{ustfd_request}()},
\code{\link{ustfd_response_payload}()},
\code{\link{ustfd_url}()}
}
\concept{ustfd_low_level}
