% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd.R
\name{ustfd_json_response}
\alias{ustfd_json_response}
\title{Process JSON Response of a Successful API Query}
\usage{
ustfd_json_response(response, ...)
}
\arguments{
\item{response}{an httr response returned by \code{\link[=ustfd_request]{ustfd_request()}}}

\item{...}{additional arguments passed to \code{httr::content}}
}
\value{
a list
}
\description{
\code{ustfd_json_response()}  will process the response to a successful request
from Fiscal Data API and translate a JSON object into a R data structure.
}
\examples{
\dontrun{
library(ustfd)
query <- ustfd_query('v1/accounting/dts/dts_table_2', sort =c('-record_date'))
response <- ustfd_request(query)
payload_table <- ustfd_response_payload(response)
payload_meta <- ustfd_response_meta_object(response)
}
}
\seealso{
Other ustfd_low_level: 
\code{\link{ustfd_request}()},
\code{\link{ustfd_response_meta_object}()},
\code{\link{ustfd_response_payload}()},
\code{\link{ustfd_url}()}
}
\concept{ustfd_low_level}
