% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vaScore.R
\name{vaScore}
\alias{vaScore}
\title{VA CVD Risk Score (2021)}
\usage{
vaScore(
  age = 50,
  race = 1,
  SBPTrt = 1,
  SBP = 150,
  TC = 100,
  HDL = 50,
  DM = 1,
  Smoke = 1,
  Depression = 1,
  verbose = TRUE
)
}
\arguments{
\item{age}{Patient age (years: 1-110)}

\item{race}{Patient race (1 = White, 2 = African American, 3 = Hispanic)}

\item{SBPTrt}{Patient is on a blood pressure medication (1 = Yes, 0 = No)}

\item{SBP}{Systolic blood pressure (mmHg: 0-300)}

\item{TC}{Total cholesterol (mg/dL: 0-400)}

\item{HDL}{HDL cholesterol (mg/dL: 0-200)}

\item{DM}{Diabetes (1 = Yes, 0 = No)}

\item{Smoke}{Current smoker (1 = Yes, 0 = No)}

\item{Depression}{Major Depression (1 = Yes, 0 = No)}

\item{verbose}{logical: should input (patient profile) be printed.}
}
\value{
Estimated 10-year CVD Risk for VA women military service
members and veterans.
}
\description{
Calculates the cardiovascular (CVD) risk score for women military service
members and veterans.
}
\examples{
library(vaRiskScore)
vaScore(age = 50,
        race = 1,
        SBPTrt = 1,
        SBP = 150,
        TC = 100,
        HDL = 50,
        DM = 1,
        Smoke = 1,
        Depression = 1,
        verbose = TRUE)
}
\references{
Jeon‐Slaughter, H., Chen, X., Tsai, S., Ramanan, B., & Ebrahimi, R. (2021).
Developing an internally validated veterans affairs women cardiovascular
disease risk score using Veterans Affairs National Electronic Health Records.
Journal of the American Heart Association, 10(5), e019217.
}
\author{
Xiaofei Chen; Haekyung Jeon‐Slaughter
}
