% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{syntax}
\alias{syntax}
\title{Syntax to define validation or indicator rules}
\description{
A concise overview of the \code{validate} syntax.
}
\section{Note}{

This document only provides a short reference. Please refer to the vignette for worked
examples.

\code{vignette("intro",package="validate")}
}

\section{Refernce the dataset as a whole}{


Metadata such as numer of rows, columns, column names and so on can be 
tested by referencing the whole data set with the '\code{.}'. For example,
the rule \code{nrow(.) == 15} checks whether there are 15 rows in the
dataset at hand.
}

\section{Local, transient assignment}{

The operator `\code{:=}' can be used to set up local variables (during, for example, validation) to save
time (the rhs of an assignment is computed only once) or to make your validation code more maintainable. 
Assignments work more or less like common R assignments: they are only valid for statements coming after 
the assignment and they may be overwritten. The result of computing the rhs is not part of a 
\code{\link{confront}}ation with data.
}

\section{Groups}{

Often the same constraints/rules are valid for groups of variables. 
\code{validate} allows for compact notation. Variable groups can be used in-statement
or by defining them with the \code{:=} operator.

\code{validator( var_group(a,b) > 0 )}

is equivalent to

\code{validator(G := var_group(a,b), G > 0)}

is equivalent to

\code{validator(a>0,b>0)}.

Using two groups results in the cartesian product of checks. So the statement

\code{validator( f=var_group(c,d), g=var_group(a,b), g > f)}

is equivalent to

\code{validator(a > c, b > c, a > d, b > d)}
}

\section{File parsing}{

Please see the vignette on how to read rules from and write rules to file:

\code{vignette("rule-files",package="validate")}
}

