% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_projection.r
\name{bed_projection}
\alias{bed_projection}
\title{Projection test for query interval overlap.}
\usage{
bed_projection(x, y, genome, by_chrom = FALSE)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{genome}{chrom sizes}

\item{by_chrom}{compute test per chromosome}
}
\value{
\code{data_frame} with the following columns:
  \itemize{ 
    \item{\code{chrom}} {the name of chromosome tested if \code{by_chrom} is \code{TRUE},
     otherwise set to \code{whole_genome}}
    \item{\code{p.value}} {p-value from a binomial test, note that p-values > 0.5
     will be reported as 1 - p-value and \code{lower_tail} will be set to \code{FALSE}}
    \item{\code{obs_exp_ratio}} {ratio of observed to expected overlap frequency}
    \item{\code{lower_tail}} {\code{TRUE} denotes that the observed number of overlaps
     is in the lower tail of the distribution (less overlap than expected), \code{FALSE}
    denotes that the observed probabililty are in the upper tail of the distribution
     (more overlap than expected)}
    }
}
\description{
Projection test for query interval overlap.
}
\details{
input tbls can be grouped using \code{\link[dplyr]{group_by}} prior to 
  analysis. Input tbls are grouped by \code{chrom} by default. Grouping by 
  \code{strand} will constrain analyses to the same strand. To compare 
  opposing strands between two tbls, strands on the \code{y} tbl can first be
  be inverted using \code{\link{flip_strands}}.
}
\examples{
genome <- tibble::tribble(
 ~chrom, ~size,
 "chr1", 1e4,
 "chr2", 2e4,
 "chr3", 4e4
)

x <- tibble::tribble(
 ~chrom, ~start, ~end,
 "chr1", 100,    200,
 "chr1", 250,    400,
 "chr1", 500,    600,
 "chr1", 1000,   2000,
 "chr2", 100,    200
)

y <- tibble::tribble(
 ~chrom, ~start, ~end,
 "chr1", 150,    175,
 "chr1", 525,    575,
 "chr1", 1100,   1200,
 "chr1", 1400,   1600,
 "chr2", 200,    1500
) 

bed_projection(x, y, genome)
bed_projection(x, y, genome, by_chrom = TRUE)

}
\seealso{
\url{http://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1002529}

Other interval-stats: \code{\link{bed_absdist}},
  \code{\link{bed_fisher}}, \code{\link{bed_jaccard}},
  \code{\link{bed_reldist}}
}

