% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_makewindows.r
\name{bed_makewindows}
\alias{bed_makewindows}
\title{Divide intervals into new sub-intervals ("windows").}
\usage{
bed_makewindows(x, genome, win_size = 0, step_size = 0, num_win = 0,
  reverse = FALSE)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}

\item{win_size}{divide intervals into fixed-size windows}

\item{step_size}{size to step before next window}

\item{num_win}{divide intervals to fixed number of windows}

\item{reverse}{reverse window numbers}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}} with \code{.win_id} column that contains a numeric
identifier for the window.
}
\description{
Divide intervals into new sub-intervals ("windows").
}
\note{
The \code{name} and \code{.win_id} columns can be used to create new
interval names (see 'namenum' example below) or in subsequent
\code{group_by} operations (see vignette).
}
\examples{
genome <- trbl_genome(
 ~chrom, ~size,
 "chr1", 200
)

x <- trbl_interval(
  ~chrom, ~start, ~end, ~name, ~score, ~strand,
  "chr1", 100,    200,  'A',   '.',    '+'
)

bed_glyph(bed_makewindows(x, genome, num_win = 10), label = '.win_id')

# Fixed number of windows
bed_makewindows(x, genome, num_win = 10)

# Fixed window size
bed_makewindows(x, genome, win_size = 10)

# Fixed window size with overlaps
bed_makewindows(x, genome, win_size = 10, step_size = 5)

# reverse win_id
bed_makewindows(x, genome, win_size = 10, reverse = TRUE)

# bedtools 'namenum'
wins <- bed_makewindows(x, genome, win_size = 10)
dplyr::mutate(wins, namenum = stringr::str_c(name, '_', .win_id))

}
\seealso{
Other utilities: \code{\link{bed12_to_exons}}
}
