% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_jaccard.r
\name{bed_jaccard}
\alias{bed_jaccard}
\title{Calculate the Jaccard statistic for two sets of intervals.}
\usage{
bed_jaccard(x, y)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{y}{\code{\link[=tbl_interval]{tbl_interval()}}}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}} with the following columns:
\itemize{
\item \code{len_i} length of the intersection
\item \code{len_u} length of the union
\item \code{jaccard} jaccard statistic
\item \code{n_int} number of intersecting intervals between \code{x} and \code{y}
}
}
\description{
Quantifies the extent of overlap between to sets of intervals in terms of
base-pairs.
}
\details{
The Jaccard statistic takes values of \code{[0,1]} and is measured as:

\deqn{ J(x,y) = \frac{\mid x \bigcap y \mid}
                     {\mid x \bigcup y \mid} =
                \frac{\mid x \bigcap y \mid}
                     {\mid x \mid + \mid y \mid -
                      \mid x \bigcap y \mid} }

Interval statistics can be used in combination with
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:do]{dplyr::do()}} to calculate
statistics for subsets of data. See \code{vignette('interval-stats')} for
examples.
}
\examples{
genome <- read_genome(valr_example('hg19.chrom.sizes.gz'))

x <- bed_random(genome, seed = 1010486)
y <- bed_random(genome, seed = 9203911)

bed_jaccard(x, y)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/jaccard.html}

Other interval statistics: \code{\link{bed_absdist}},
  \code{\link{bed_fisher}}, \code{\link{bed_projection}},
  \code{\link{bed_reldist}}
}
