% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_random.r
\name{bed_random}
\alias{bed_random}
\title{Generate randomly placed intervals on a genome.}
\usage{
bed_random(genome, length = 1000, n = 1e+06, sort_by = c("chrom",
  "start"), seed = 0)
}
\arguments{
\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}

\item{length}{length of intervals}

\item{n}{number of intervals to generate}

\item{sort_by}{sorting variables}

\item{seed}{seed RNG for reproducible intervals}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
Generate randomly placed intervals on a genome.
}
\details{
Sorting can be suppressed with \code{sort_by = NULL}.
}
\examples{
genome <- trbl_genome(
  ~chrom,  ~size,
  "chr1",  10000000,
  "chr2",  50000000,
  "chr3",  60000000,
  "chrX",  5000000
)

bed_random(genome, seed = 10104)

# sorting can be suppressed
bed_random(genome, sort_by = NULL, seed = 10104)

# 500 random intervals of length 500
bed_random(genome, length = 500, n = 500, seed = 10104)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/random.html}

Other randomizing operations: \code{\link{bed_shuffle}}
}
