% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_sort.r
\name{bed_sort}
\alias{bed_sort}
\title{Sort a set of intervals.}
\usage{
bed_sort(x, by_size = FALSE, by_chrom = FALSE, reverse = FALSE)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{by_size}{sort by interval size}

\item{by_chrom}{sort within chromosome}

\item{reverse}{reverse sort order}
}
\description{
Sort a set of intervals.
}
\examples{
x <- trbl_interval(
   ~chrom, ~start, ~end,
   "chr8", 500,    1000,
   "chr8", 1000,   5000,
   "chr8", 100,    200,
   "chr1", 100,    300,
   "chr1", 100,    200
)

# sort by chrom and start
bed_sort(x)

# reverse sort order
bed_sort(x, reverse = TRUE)

# sort by interval size
bed_sort(x, by_size = TRUE)

# sort by decreasing interval size
bed_sort(x, by_size = TRUE, reverse = TRUE)

# sort by interval size within chrom
bed_sort(x, by_size = TRUE, by_chrom = TRUE)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/sort.html}
}
