% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxRCSBinfoSheet}
\alias{oxRCSBinfoSheet}
\title{openxlsx PDB/RCSB Summary Sheet}
\usage{
oxRCSBinfoSheet(wb.name, sheet.name = "RCSB_information", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
"PDB_information"}

\item{df}{data.frame containing the PDB/RCSB information obtatined within the
\code{\link[=ConservedWaters]{ConservedWaters()}} function; \emph{e.g.}, \code{pdbs.information}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs the \link{openxlsx} worksheet for the Similarity
Summary analysis.
}
\details{
\strong{This function is to \emph{ONLY} be used with the results of
\code{\link[=ConservedWaters]{ConservedWaters()}}}. Specific aspects of how the
returned \code{data.frame} will be formatted are \strong{hard-coded} into this
function.

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxAlignOverlapSheet}},
  \code{\link{oxClusterStatsSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxInitWaterDataSheet}},
  \code{\link{oxPDBcleanedSummarySheet}},
  \code{\link{oxPlainDataSheet}},
  \code{\link{oxWaterOccurrenceSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
