% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{write.conservedWaters.pdb}
\alias{write.conservedWaters.pdb}
\title{Write Conserved Waters to PDB File}
\usage{
write.conservedWaters.pdb(file, h2o.clusters.summary)
}
\arguments{
\item{file}{Filename with ".pdb" extension.}

\item{h2o.clusters.summary}{The conserved water clusters summary.}
}
\value{
Writes a PDB file with the X, Y, and Z coordinates, percent conserved
within the analyzed structures, and the calculated B-value for the oxygen
atoms of the clustered waters.
}
\description{
Writes conserved water information to a PDB file.
}
\details{
Using the \code{\link[bio3d:write.pdb]{bio3d::write.pdb()}} function this function writes a PDB
file for the conserved water oxygen atoms with the percentage of structures
with a water participting in the cluster (written to the occupancy column)
and the calculated B-value -- using the rmsf of the waters in the cluster
-- for the waters participating in the cluster (written to the B-value
column). This function is called from the \code{\link[=ConservedWaters]{ConservedWaters()}} function.

All water molecules will include the water's oxygen atom (\code{elety}), be
assigned the residue name (\code{resid}) \code{HOH}, and the chain (\code{chain}) \code{A}
while the atom number (\code{eleno}) and residue number (\code{resno}) both start at
\code{1}.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
    write.conservedWaters.pdb(file = "system_conservedWaters.pdb",
                              h2o.clusters.summary)
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
