% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_input_attributes.R
\name{vapour_read_attributes}
\alias{vapour_read_attributes}
\title{Read feature attribute data}
\usage{
vapour_read_attributes(dsource, layer = 0L, sql = "")
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{layer}{integer of layer to work with, defaults to the first (0) or the name of the layer}

\item{sql}{if not empty this is executed against the data source (layer will be ignored)}
}
\description{
Read features attributes, optionally after SQL execution.
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
att <- vapour_read_attributes(mvfile)
str(att)
sq <- "SELECT * FROM list_locality_postcode_meander_valley WHERE FID < 5"
(att <- vapour_read_attributes(mvfile, sql = sq))
pfile <- "list_locality_postcode_meander_valley.tab"
dsource <- system.file(file.path("extdata/tab", pfile), package="vapour")
SQL <- "SELECT NAME FROM list_locality_postcode_meander_valley WHERE POSTCODE < 7300"
vapour_read_attributes(dsource, sql = SQL)
}
