% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_read_block.R
\name{vapour_create}
\alias{vapour_create}
\title{Create raster file}
\usage{
vapour_create(
  filename,
  driver = "GTiff",
  extent = c(-180, 180, -90, 90),
  dimension = c(2048, 1024),
  projection = "OGC:CRS84",
  n_bands = 1L,
  overwrite = FALSE
)
}
\arguments{
\item{filename}{filename/path to create}

\item{driver}{GDAL driver to use (GTiff is default, and recommended)}

\item{extent}{xmin,xmax,ymin,ymax 4-element vector}

\item{dimension}{dimension of the output, X * Y}

\item{projection}{projection of the output, best to use a full WKT but any string accepted}

\item{n_bands}{number of bands in the output, default is 1}

\item{overwrite}{not TRUE by default}
}
\value{
the file path that was created
}
\description{
This is in an incomplete interface to raster writing, for exploring.
}
\details{
If GeoTIFF is used (\code{driver = "GTiff"}, recommended) then the output is tiled 512x512, and has DEFLATE compression, and
is sparse when created (no values are initiated, so the file is tiny).

Note that there is no restriction on where you can read or write from, the responsibility is yours. In future we will
allow control of output tiling and data type etc.
}
\examples{
tfile <- tempfile(fileext = ".tif")
if (!file.exists(tfile)) {
 vapour_create(tfile, extent = c(-1, 1, -1, 1) * 1e6, 
                     dimension = c(128, 128), 
                     projection = "+proj=laea")
 file.remove(tfile)
}
}
