\name{SVEC}

\alias{SVEC}

\alias{print.svecest}

\title{Estimation of a SVEC}

\encoding{latin1}

\description{
  Estimates an SVEC by utilising a scoring algorithm.  
}
  
\usage{
SVEC(x, LR = NULL, SR = NULL, r = 1, start = NULL, max.iter = 100,
conv.crit = 1e-07, maxls = 1.0, lrtest = TRUE, boot = FALSE, runs = 100)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{ca.jo}}; generated by
    \command{ca.jo()} contained in \code{urca}.}
  \item{LR}{Matrix of the restricted long run impact matrix.}
  \item{SR}{Matrix of the restricted contemporaneous impact matrix.}
  \item{r}{Integer, the cointegration rank of x.}  
  \item{start}{Vector of starting values for \eqn{\gamma}.}  
  \item{max.iter}{Integer, maximum number of iteration.}
  \item{conv.crit}{Real, convergence value of algorithm..}
  \item{maxls}{Real, maximum movement of the parameters between two
    iterations of the scoring algorithm.}
  \item{lrtest}{Logical, over-identification LR test, the result is set
    to \command{NULL} for just-identified system.}
  \item{boot}{Logical, if \code{TRUE}, standard errors of the parameters
    are computed by bootstrapping. Default is \code{FALSE}.}
  \item{runs}{Integer, number of bootstrap replications.}  
}

\details{
  Consider the following reduced form of a k-dimensional vector
  error correction model: 

  \deqn{
    A \Delta \bold{y}_t = \Pi \bold{y}_{t-1} + \Gamma_1 \Delta
    \bold{y}_{t-1} + \ldots + \Gamma_p \Delta \bold{y}_{t-p + 1} +
    \bold{u}_t \quad .}

  This VECM has the following MA representation:

  \deqn{
    \bold{y}_t = \Xi \sum_{i=1}^t \bold{u}_i + \Xi^*(L)\bold{u}_t +
    \bold{y}_0^* \quad ,}

  with \eqn{\Xi = \beta_{orth} (\alpha_{orth}'(I_K -
    \sum_{i=1}^{p-1}\Gamma_i)\beta_{orth} )^{-1}\alpha_{orth}'} and
  \eqn{\Xi^*(L)} signifies an infinite-order polynomial in the lag
  operator with coefficient matrices \eqn{\Xi^*_j} that tends to zero
  with increasing size of \eqn{j}.\cr 

  Contemporaneous restrictions on the impact matrix \eqn{B} must be
  supplied as zero entries in \code{SR} and free parameters as \code{NA}
  entries. Restrictions on the long run impact matrix \eqn{\Xi B} have
  to be supplied likewise. The unknown parameters are estimated by
  maximising the concentrated log-likelihood subject to the imposed
  restrictions by utilising a scoring algorithm on:

  \deqn{
    \ln L_c(A, B) = - \frac{KT}{2}\ln(2\pi) + \frac{T}{2}\ln|A|^2 -
    \frac{T}{2}\ln|B|^2 - \frac{T}{2}tr(A'B'^{-1}B^{-1}A\tilde{\Sigma}_u) 
  }

  with \eqn{\tilde{\Sigma}_u} signifies the reduced form
  variance-covariance matrix and \eqn{A} is set equal to the identity
  matrix \eqn{I_K}.

  If \sQuote{\code{start}} is not set, then normal random numbers are used as
  starting values for the unknown coefficients. In case of an
  overidentified SVEC, a likelihood ratio statistic is computed according to:

  \deqn{
    LR = T(\ln\det(\tilde{\Sigma}_u^r) - \ln\det(\tilde{\Sigma}_u))
    \quad , }
  
  with \eqn{\tilde{\Sigma}_u^r} being the restricted variance-covariance
  matrix and \eqn{\tilde{\Sigma}_u} being the variance covariance matrix
  of the reduced form residuals. The test statistic is distributed as
  \eqn{\chi^2(K*(K+1)/2 - nr)}, where \eqn{nr} is equal to the number of
  restrictions.   
}

\value{
  A list of class \sQuote{\code{svecest}} with the following elements is
  returned:\cr
  
  \item{SR}{The estimated contemporaneous impact matrix.}
  \item{SRse}{The standard errors of the contemporaneous impact matrix,
    if \code{boot = TRUE}.}
  \item{LR}{The estimated long run impact matrix.}
  \item{LRse}{The standard errors of the long run impact matrix,
    if \code{boot = TRUE}.}  
  \item{Sigma.U}{The variance-covariance matrix of the reduced form
    residuals times 100, \emph{i.e.}, \eqn{\Sigma_U = A^{-1}BB'A^{-1'}
      \times 100}.}
  \item{Restrictions}{Vector, containing the ranks of the restricted
    long run and contemporaneous impact matrices.}
  \item{LRover}{Object of class \sQuote{code{htest}}, holding the Likelihood
  ratio overidentification test.}
  \item{start}{Vector of used starting values.}
  \item{type}{Character, type of the SVEC-model.}
  \item{var}{The \sQuote{\code{ca.jo}} object \sQuote{\code{x}}.} 
  \item{call}{The \code{call} to \command{SVEC()}.}
}

\author{Bernhard Pfaff}

\references{
  Amisano, G. and C. Giannini (1997), \emph{Topics in Structural VAR
    Econometrics}, 2nd edition, Springer, Berlin.

  Breitung, J., R. Brggemann and H. Ltkepohl (2004), Structural vector
  autoregressive modeling and impulse responses, in H. Ltkepohl and
  M. Krtzig (editors), \emph{Applied Time Series Econometrics},
  Cambridge University Press, Cambridge.
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link{SVAR}}, \code{\link{SVAR2}}, 
}

\examples{
data(Canada)
vec.can <- ca.jo(Canada, K = 2, spec = "transitory")
summary(vec.can)
LR <- matrix(NA, nrow = 4, ncol = 4)
SR <- diag(NA, 4)
SR[2, 1] <- NA
SR[3, 1] <- NA
SR[4, 1] <- NA
SVEC(vec.can, r = 2, LR = LR, SR = SR, lrtest = TRUE)
}

\keyword{regression}
\concept{SVEC}
\concept{SVECM}
\concept{Structural VECM}
\concept{Structural Vector Error Correction Model}
\concept{B-model}
