% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_functions.R
\name{init_bounds_optim}
\alias{init_bounds_optim}
\title{Setting of Optimization Bounds and Initial Values}
\usage{
init_bounds_optim(control, p, q, id_obj, med_dist, y_var, OLS_mu)
}
\arguments{
\item{control}{(\code{\link{SVC_mle_control}} output, i.e. \code{list})}

\item{p}{(\code{numeric(1)}) \cr Number of fixed effects}

\item{q}{(\code{numeric(1)}) \cr Number of SVCs}

\item{id_obj}{(\code{numeric(2*q+1+q)}) \cr Index vector to identify the
arguments of objective function.}

\item{med_dist}{(\code{numeric(1)}) \cr Median distance between observations}

\item{y_var}{(\code{numeric(1)}) \cr Variance of response \code{y}}

\item{OLS_mu}{(\code{numeric(p)}) \cr Coefficient estimates of ordinary
least squares (OLS).}
}
\value{
A \code{list} with three entries: \code{lower}, \code{init},
and \code{upper}.
}
\description{
Sets bounds and initial values for \code{\link[stats]{optim}} by
extracting potentially given values from \code{\link{SVC_mle_control}} and
checking them, or calculating them from given data. See Details.
}
\details{
If values are not provided, then they are set in the following way.
Let \eqn{d} be the median distance \code{med_dist}, let \eqn{s^2_y} be
the variance of the response \code{y_var}, and let \eqn{b_j} be the OLS
coefficients of the linear model. The computed values are given in the
table below.\tabular{lrrr}{
   Parameter \tab Lower bound \tab Initial Value \tab Upper Bound \cr
   Range \tab \eqn{d/1000} \tab \eqn{d/4} \tab \eqn{10 d} \cr
   Variance \tab \eqn{0} \tab \eqn{s^2_y/(q+1)} \tab \eqn{10s^2_y} \cr
   Nugget \tab \eqn{10^{-6}} \tab \eqn{s^2_y/(q+1)} \tab \eqn{10s^2_y} \cr
   Mean \eqn{j} \tab \code{-Inf} \tab \eqn{b_j} \tab \code{Inf} \cr
}
}
\author{
Jakob Dambon
}
