% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfR-method.R
\docType{methods}
\name{show,vcfR-method}
\alias{[,vcfR-method}
\alias{dim,vcfR-method}
\alias{dim.vcfR}
\alias{head,vcfR-method}
\alias{nrow,vcfR-method}
\alias{nrow.vcfR}
\alias{plot,vcfR-method}
\alias{plot.vcfR}
\alias{rbind2,vcfR,ANY-method}
\alias{rbind2,vcfR,missing-method}
\alias{rbind2,vcfR,vcfR-method}
\alias{rbind2.vcfR}
\alias{show,vcfR-method}
\alias{vcfR-method}
\title{vcfR-method}
\usage{
\S4method{show}{vcfR}(object)

\S4method{head}{vcfR}(x, n = 6, maxchar = 80)

\S4method{[}{vcfR}(x, i, j, drop)

\S4method{plot}{vcfR}(x, y, ...)

\S4method{rbind2}{vcfR,missing}(x, y, ...)

\S4method{rbind2}{vcfR,ANY}(x, y, ...)

\S4method{rbind2}{vcfR,vcfR}(x, y, ...)

\S4method{dim}{vcfR}(x)

\S4method{nrow}{vcfR}(x)
}
\arguments{
\item{object}{object1 of class vcfR}

\item{x}{object of class vcfR}

\item{n}{number of rows to print}

\item{maxchar}{maximum number of characters to print per line





##### Method show #####}

\item{i}{vector of rows (variants) to include}

\item{j}{vector of columns (samples) to include}

\item{drop}{delete the dimensions of an array which only has one level}

\item{y}{not used}

\item{...}{Arguments to be passed to methods}
}
\description{
Methods to show, subset or plot data from objects of class vcfR

\strong{head} returns the first parts of an object of class vcfR.

The brackets ('[]') subset objects of class vcfR

The \strong{plot} method visualizes objects of class vcfR
}
\details{
The method \strong{show} is used to display an object.
Because vcf data are relatively large, this has been abbreviated.
Here we display the first four lines of the meta section, and truncate them to no more than 80 characters.
The first eight columns and six rows of the fix section are also displayed.

The method \strong{head} is similar to show, but is more flexible.
The number of rows displayed is parameterized by  the variable n.
And the maximum number of characters to print per line (row) is also parameterized.
In contract to show, head includes a summary of the gt portion of the vcfR object.

The \strong{square brackets ([])} are used to subset objects of class vcfR.
Rows are subset by providing a vector i to specify which rows to use.
The columns in the fix slot will not be subset by j.
The parameter j is a vector used to subset the columns of the gt slot.
Note that it is essential to include the first column here (FORMAT) or downsream processes will encounter trouble.

The \strong{plot} method generates a histogram from data found in the 'QUAL' column from the 'fix' slot.
}

