% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfR2migrate.R
\name{vcfR2migrate}
\alias{vcfR2migrate}
\title{Convert a vcfR object to MigrateN input file}
\usage{
vcfR2migrate(vcf, pop, in_pop, out_file = "MigrateN_infile.txt",
  method = c("N", "H"))
}
\arguments{
\item{vcf}{a vcfR object.}

\item{pop}{factor indicating population membership for each sample.}

\item{in_pop}{vector of population names indicating which population to include in migrate output file.}

\item{out_file}{name of output file.}

\item{method}{should 'N' or 'H' format data be generated?}
}
\value{
a text file that can be used as an input for MigrateN software (SNP format).
}
\description{
The function converts a vcfR object to a text format that can be used as an infile for MigrateN.
}
\details{
This function converts a vcfR object to a text file which can be used as input for MigrateN.
The function will remove loci with missing data, indels, and loci that are not bialleleic (loci with more than two alleles). 
Thus, only SNP data analysed where the length of each locus (inmutational steps) is 1 (as opposed to microsatellites or indels).
}
\examples{
\dontrun{
data(vcfR_example)
my_pop <- as.factor(paste("pop_", rep(c("A", "B", "C"), each = 6), sep = ""))
vcfR2migrate(vcf = vcf , pop = my_pop , in_pop = c("pop_A","pop_C"),
             out_file = "my2pop.txt", method = 'H')
}


}
\seealso{
\href{http://popgen.sc.fsu.edu/Migrate/Migrate-n.html}{Migrate-N} website.
}
\author{
Shankar Shakya and Brian J. Knaus
}
