% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vcfwriter}
\alias{vcfwriter}
\title{API for writing the VCF/BCF.}
\value{
A C++ class with the following fields/methods for writing the VCF/BCF
}
\description{
Type the name of the class to see the details and methods
}
\section{Fields}{

\describe{
\item{\code{new}}{Constructor given a vcf file \itemize{
\item Parameter: vcffile - The path of a vcf file. don't start with "~"
\item Parameter: version - The version of VCF specification
}}

\item{\code{addContig}}{Add a Contig in the header of the vcf
\itemize{ \item Parameter: str - A string for the CONTIG name }}

\item{\code{addFILTER}}{Add a FILTER in the header of the vcf
\itemize{
\item Parameter: id - A string for the FILTER name
\item Parameter: desc - A string for description of what it means}}

\item{\code{addINFO}}{Add a INFO in the header of the vcf
\itemize{
\item Parameter: id - A string for the tag name
\item Parameter: number - A string for the number
\item Parameter: type - A string for the type
\item Parameter: desc - A string for description of what it means}}

\item{\code{addFORMAT}}{Add a FORMAT in the header of the vcf
\itemize{
\item Parameter: id - A string for the tag name
\item Parameter: number - A string for the number
\item Parameter: type - A string for the type
\item Parameter: desc - A string for description of what it means}}

\item{\code{addSample}}{Add a SAMPLE in the header of the vcf
\itemize{ \item Parameter: str - A string for a SAMPLE name }}

\item{\code{addLine}}{Add a line in the header of the vcf
\itemize{ \item Parameter: str - A string for a line in the header of VCF }}

\item{\code{writeline}}{Write a variant record given a line
\itemize{ \item Parameter: line - A string for a line in the variant of VCF. Not ended with "newline" }}

\item{\code{close}}{Close and save the vcf file}
}}

\examples{
outvcf <- paste0(tempfile(), ".vcf.gz")
bw <- vcfwriter$new(outvcf, "VCF4.3")
bw$addContig("chr20")
bw$addINFO("AF", "A", "Float", "Estimated allele frequency in the range (0,1)");
bw$addFORMAT("GT", "1", "String", "Genotype");
bw$addSample("NA12878")
bw$addSample("NA12879")
s1 <- "chr20\t2006060\trs146931526\tG\tC\t100\tPASS\tAF=0.000998403\tGT\t1|0\t1/1"
bw$writeline(s1)
bw$close()
}
