% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.mean.ps}
\alias{meta.lc.mean.ps}
\title{Confidence interval for a linear contrast of mean differences from
paired-samples studies}
\usage{
meta.lc.mean.ps(alpha, m1, m2, sd1, sd2, cor, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for group 1}

\item{m2}{vector of estimated means for group 2}

\item{sd1}{vector of estimated SDs for group 1}

\item{sd2}{vector of estimated SDs for group 2}

\item{cor}{vector of estimated correlations for paired measurements}

\item{n}{vector of sample sizes}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the estimate for the contrast. The matrix
has the following columns:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of paired-samples mean differences from two or more studies.
A Satterthwaite adjustment to the degrees of freedom is used to improve
the accuracy of the confidence interval. Equal variances within or across
studies is not assumed.
}
\examples{
m1 <- c(53, 60, 53, 57)
m2 <- c(55, 62, 58, 61)
sd1 <- c(4.1, 4.2, 4.5, 4.0)
sd2 <- c(4.2, 4.7, 4.9, 4.8)
cor <- c(.7, .7, .8, .85)
n <- c(30, 50, 30, 70)
v <- c(.5, .5, -.5, -.5)
meta.lc.mean.ps(.05, m1, m2, sd1, sd2, cor, n, v)

# Should return:
#          Estimate        SE       LL       UL      df
# Contrast      2.5 0.4943114 1.520618 3.479382 112.347


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
