% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.meanratio2}
\alias{meta.lc.meanratio2}
\title{Confidence interval for a log-linear contrast of mean ratios from
2-group studies}
\usage{
meta.lc.meanratio2(alpha, m1, m2, sd1, sd2, n1, n2, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for group 1}

\item{m2}{vector of estimated means for group 2}

\item{sd1}{vector of estimated SDs for group 1}

\item{sd2}{vector of estimated SDs for group 2}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimated log-linear contrast
\item SE - standard error of log-linear contrast
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - exponentiated log-linear contrast
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
\item df - degrees of freedom
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
log-linear contrast of 2-group mean ratio from two or more studies. A
Satterthwaite adjustment to the degrees of freedom is used to improve
the accuracy of the confidence interval. Equality of variances within or across
studies is not assumed.
}
\examples{
m1 <- c(45.1, 39.2, 36.3, 34.5)
m2 <- c(30.0, 35.1, 35.3, 36.2)
sd1 <- c(10.7, 10.5, 9.4, 11.5)
sd2 <- c(12.3, 12.0, 10.4, 9.6)
n1 <- c(40, 20, 50, 25)
n2 <- c(40, 20, 48, 26)
v <- c(.5, .5, -.5, -.5)
meta.lc.meanratio2(.05, m1, m2, sd1, sd2, n1, n2, v)

# Should return:
#           Estimate         SE        LL        UL  exp(Estimate)
# Contrast 0.2691627 0.07959269 0.1119191 0.4264064      1.308868
#           exp(LL)  exp(UL)       df
# Contrast 1.118422 1.531743 152.8665


}
\references{
\insertRef{Bonett2020}{vcmeta}
}
