% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.cohen}
\alias{se.cohen}
\title{Computes the standard error for Cohen's d}
\usage{
se.cohen(d, n1, n2)
}
\arguments{
\item{d}{estimated Cohen's d}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - Cohen's d (from input)
\item SE - standard error
}
}
\description{
This function computes the standard error of Cohen's d using only the two
sample sizes and an estimate of Cohen's d. Cohen's d and its standard error
assume equal variances. The estimate of Cohen's d, with the standard error
output from this function, can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions in
applications where different types of compatible standardized mean
differences are used in the meta-analysis.
}
\examples{
se.cohen(.78, 35, 50)

# Should return: 
#            Estimate        SE
# Cohen's d:     0.78 0.2288236


}
\seealso{
\link[vcmeta]{se.stdmean2}
}
