% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R
\name{vec_cast}
\alias{vec_cast}
\alias{vec_cast_common}
\alias{vec_restore}
\alias{vec_cast.logical}
\alias{vec_cast.integer}
\alias{vec_cast.double}
\alias{vec_cast.character}
\alias{vec_cast.list}
\title{Cast a vector to specified type}
\usage{
vec_cast(x, to)

vec_cast_common(..., .to = NULL)

vec_restore(x, to)

\method{vec_cast}{logical}(x, to)

\method{vec_cast}{integer}(x, to)

\method{vec_cast}{double}(x, to)

\method{vec_cast}{character}(x, to)

\method{vec_cast}{list}(x, to)
}
\arguments{
\item{x, ...}{Vectors to cast.}

\item{to, .to}{Type to cast to. If \code{NULL}, \code{x} will be returned as is.}
}
\value{
A vector the same length as \code{x} with the same type as \code{to},
or an error if the cast is not possible. A warning is generated if
information is lost when casting between compatible types (i.e. when
there is no 1-to-1 mapping for a specific value).
}
\description{
\code{vec_cast()} provides general coercions from one type of vector to another,
and along with \code{\link[=vec_type2]{vec_type2()}} forms the foundation of the vctrs type system.
It should generally not be called by R users, but is important for R
developers. \code{vec_restore()} is designed specifically for casting a bare
vector to the original type; it's useful when relying \code{NextMethod()} for
the actual implementation. \code{vec_cast_common(...)} casts a collection to
vectors to the same type.
}
\section{Casting rules}{

Casting is more flexible than coercion, and allows for the possibility of
information loss. This diagram summarises possible coercions. \code{vec_cast()}
from any type connected to another type, provided that the arrows are
followed in only one direction. For example you can cast from logical to
character, and list to time, but you can not cast from logical to datetime.

\figure{cast.png}

Most casts are not symmetric: you can cast all integers to doubles, but you
can only cast a subset of doubles back to integers. If a cast is potentially
lossy, a warning message will be shown whenever an actual loss occurs
(which may only be for some elements of a vector).

The rules for coercing from a list are fairly strict: each component of the
list must be of length 1, and must be coercible to type \code{to}. This ensures
that a round-trip to and form list is possible, without opening the door
to very flexible list flattening (which should be the job of a more
specialised function).
}

\section{S3 dispatch}{

\code{vec_cast()} dispatches on both arguments because casting depends on both
the type of \code{x} and of \code{to}. This is implemented by having methods of
\code{vec_cast()}, e.g. \code{vec_cast.integer()} also be S3 generics, which call
e.g. \code{vec_cast.integer.double()}.

Note that \code{vec_cast()} dispatch on its second argument, so that the name
of the final method uses the same convention as \code{as.xyz()} methods, i.e.
\code{vec_cast.integer.double()} casts double to integers, in the same way
that \code{as.integer.double()} would.

Whenever you implemenet a \code{vec_cast.new_class()} generic/method,
make sure to always provide \code{vec_cast.new_class.default()} (
which should call \code{\link[=stop_incompatible_cast]{stop_incompatible_cast()}}) and
\code{vec_cast.new_class.vctrs_unspecified()} (which should call
\code{\link[=vec_unspecified_cast]{vec_unspecified_cast()}}).

See \code{vignette("s3-vector")} for full details.
}

\section{Restoring attributes}{


A restore is a specialised type of cast, primarily used in conjunction
with \code{NextMethod()} or a C-level function that works on the underlying
data structure. A \code{vec_restore()} method can assume that \code{x} has the
correct type (although the length may be different) but all attributes
have been lost and need to be restored. In other words,
\code{vec_restore(vec_data(x), x)} should yield \code{x}.

To understand the difference between \code{vec_cast()} and \code{vec_restore()}
think about factors: it doesn't make sense to cast an integer to a factor,
but if \code{NextMethod()} or other low-level function has stripped attributes,
you still need to be able to restore them.

The default method copies across all attributes so you only need to
provide your own method if your attributes require special care
(i.e. they are dependent on the data in somew way). When implementing
your own method, bear in mind that many R users add attributes to track
additional metadat that is important to them, so you should preserve any
attributes that don't require special handling for your class.
}

\examples{
# x is a double, but no information is lost
vec_cast(1, integer())

# Information is lost so a warning is generated
\dontrun{
vec_cast(1.5, integer())
}

# No sensible coercion is possible so an error is generated
\dontrun{
vec_cast(1.5, factor("a"))
}

# Cast to common type
vec_cast_common(factor("a"), factor(c("a", "b")))
vec_cast_common(factor("a"), Sys.Date(), .to = list())
}
\keyword{internal}
