% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inventory.R
\name{inventory}
\alias{inventory}
\title{Inventory function.}
\usage{
inventory(name, vehcomp = c(PC = 1, LCV = 1, HGV = 1, BUS = 1, MC = 1),
  show.main = TRUE, scripts = TRUE, show.dir = TRUE,
  show.scripts = FALSE, clear = TRUE, rush.hour = FALSE)
}
\arguments{
\item{name}{Character, one word indicating the name of the main directory for running
vein. It is better to write the pull path to the new directory.}

\item{vehcomp}{Vehicular composition of the fleet. It is required a named
numerical vector with the names "PC", "LCV", "HGV", "BUS" and "MC". In the
case that tthere are no vehiles for one category of the composition, the name
should be included with the number zero, for example PC = 0. The maximum
number allowed is 99 per category.}

\item{show.main}{Logical; Do you want to see the new main.R file?}

\item{scripts}{Logical Do you want to generate or no R scripts?}

\item{show.dir}{Logical value for printing the created directories.}

\item{show.scripts}{Logical value for printing the created scripts.}

\item{clear}{Logical value for removing recursively the directory and create
another one.}

\item{rush.hour}{Logical, to create a template for morning rush hour.}
}
\value{
Structure of directories and scripts for automating compilation of
vehicular emissions inventory. The structure can be used with other type of
sources of emissions. The structure of the directories is: daily, ef, emi,
est, images, network and veh. This structure is a suggestion and the user can
use another.
'
ef: it is for storing the emission factors data-frame, similar to data(fe2015)
but including one column for each of the categories of the vehicular
composition. For intance, if PC = 5, there should be 5 columns with emission
factors in this file. If LCV = 5, another 5 columns should be present, and
so on.

emi: Directory for saving the estimates. It is suggested to use .rds
extension instead of .rda.

est: Directory with subdirectories matching the vehicular composition for
storing the scripts named input.R.

images: Directory for saving images.

network: Directory for saving the road network with the required attributes.
This file will includes the vehicular flow per street to be used by age*
functions.

veh: Directory for storing the distribution by age of use of each category of
the vehicular composition. Those are data-frames with number of columns with
the age distribution and number of rows as the number of streets. The class
of these objects is "Vehicles". Future versions of vein will generate
Vehicles objects with the explicit spatial component.

The name of the scripts and directories are based on the vehicular
composition, however, there is included a file named main.R which is just
an R script to estimate all the emissions. It is important to note that the
user must add the emission factors for other pollutants. Also, this function
creates the scripts input.R where the user must specify the inputs for the
estimation of emissions of each category. Also, there is a file called
traffic.R to generates objects of class "Vehicles".
The user can rename these scripts.
}
\description{
\code{inventory} produces an structure of directories and scripts
in order to run vein. It is required to know the vehicular composition of the
fleet.
}
\examples{
\dontrun{
name = file.path(tempdir(), "YourCity")
inventory(name = name, show.dir = TRUE, show.scripts = TRUE)
source(paste0(name, "/main.R"))
}

}
