# can deploy via `vetiver_deploy_sagemaker()`

    Code
      vetiver_deploy_sagemaker(b, "cars1", instance_type)
    Condition
      Error in `vetiver_deploy_sagemaker()`:
      ! `board` must be an S3 pins board, not a <pins_board_folder/pins_board> object.

# can create correct files for `vetiver_sm_build()`

    Code
      cat(readr::read_lines(fs::path(tmp_dir, "plumber.R")), sep = "\n")
    Output
      # Generated by the vetiver package; edit with care
      
      library(pins)
      library(plumber)
      library(rapidoc)
      library(vetiver)
      b <- board_folder(path = "<redacted>")
      v <- vetiver_pin_read(b, "cars1")
      
      #* @plumber
      function(pr) {
          pr %>% vetiver_api(v, path = "/invocations")
      }

---

    Code
      cat(readr::read_lines(file.path(tmp_dir, "Dockerfile")), sep = "\n")
    Output
      # Generated by the vetiver package; edit with care
      
      FROM rocker/r-ver:<r_version>
      ENV RENV_CONFIG_REPOS_OVERRIDE https://packagemanager.rstudio.com/cran/latest
      
      RUN apt-get update -qq && apt-get install -y --no-install-recommends \
        libcurl4-openssl-dev \
        libicu-dev \
        libsodium-dev \
        libssl-dev \
        make \
        zlib1g-dev \
        && apt-get clean
      
      COPY vetiver_renv.lock renv.lock
      RUN Rscript -e "install.packages('renv')"
      RUN Rscript -e "renv::restore()"
      COPY plumber.R /opt/ml/plumber.R
      EXPOSE 8080
      ENTRYPOINT ["R", "-e", "pr <- plumber::plumb('/opt/ml/plumber.R'); pr$run(host = '0.0.0.0', port = 8080)"]

# can create SageMaker Model

    Code
      vetiver_sm_model(image_uri = image_uri, role = role, tags = "potato")
    Condition
      Error in `vetiver_sm_model()`:
      ! `tags` must be a list, not the string "potato".
    Code
      vetiver_sm_model(image_uri = image_uri, role = role, tags = list("potato"))
    Condition
      Error in `vetiver_sm_model()`:
      ! `tags` must have valid names, like `list("my-tag" = "my-value")`
    Code
      vetiver_sm_model(image_uri = image_uri, role = role, vpc_config = list("potato"))
    Condition
      Error in `vetiver_sm_model()`:
      ! `subnet` must be a list, not `NULL`.
    Code
      vetiver_sm_model(image_uri = image_uri, role = role, vpc_config = list(Subnets = list(
        1:3), SecurityGroupIds = 1:3))
    Condition
      Error in `vetiver_sm_model()`:
      ! `security_group_ids` must be a list, not an integer vector.
    Code
      vetiver_sm_model(image_uri = image_uri, role = role, vpc_config = list(Subnets = 1:
        3, SecurityGroupIds = list(1:3)))
    Condition
      Error in `vetiver_sm_model()`:
      ! `subnet` must be a list, not an integer vector.

# can create SageMaker Endpoint

    Code
      vetiver_sm_endpoint(model_name = model_name, instance_type = instance_type,
        tags = "potato")
    Condition
      Error in `vetiver_sm_endpoint()`:
      ! `tags` must be a list, not the string "potato".
    Code
      vetiver_sm_endpoint(model_name = model_name, instance_type = instance_type,
        tags = list("potato"))
    Condition
      Error in `vetiver_sm_endpoint()`:
      ! `tags` must have valid names, like `list("my-tag" = "my-value")`

# can call sm_create_endpoint

    Code
      out <- sm_create_endpoint(client, endpoint_name, config_name, wait = FALSE)
    Message
      Creating endpoint with name "vetiver-sagemaker-example-model"

# can delete SageMaker endpoints

    Code
      vetiver_sm_delete(object)
    Condition
      Warning:
      Unable to delete "vetiver-sagemaker-example-model" endpoint configuration.

# can create vetiver endpoint object

    Code
      vetiver_endpoint_sagemaker(list())
    Condition
      Error in `vetiver_endpoint_sagemaker()`:
      ! `model_endpoint` must be a character vector, not an empty list.

---

    Code
      vetiver_endpoint_sagemaker(model_endpoint)
    Output
      
      -- A SageMaker model endpoint for prediction: 
      Model endpoint: vetiver-sagemaker-example-model
      Region: my-region

