% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mygls.R
\name{mygls}
\alias{mygls}
\title{Our generalized least squares ls function}
\usage{
mygls(
  model,
  data = sys.frame(sys.parent()),
  correlation = NULL,
  weights = NULL,
  subset,
  method = c("REML", "ML"),
  na.action = na.fail,
  control = list(),
  verbose = FALSE
)
}
\arguments{
\item{model}{a \code{formula}.}

\item{data}{a \code{data.frame} containing variables called in \code{model}, \code{correlation}, \code{weights}, \code{subset}.}

\item{correlation}{a \code{corCompSymm} object. Default is \code{NULL}.}

\item{weights}{a \code{varIdent} object. Default is \code{NULL}.}

\item{subset}{an optional expression indicating which subset of the rows of \code{data} should be used in the fit. By default, all observations are included.}

\item{method}{a character string to choose the maximization method. Default is "\code{REML}".}

\item{na.action}{a function that indicates what should happen when the data contain NAs. Default is \code{na.fail}.}

\item{control}{a list of control values. Default is an empty list.}

\item{verbose}{an optional logical value. If TRUE information on the evolution of the iterative algorithm is printed. Default is FALSE.}
}
\value{
a \code{gls} object
}
\description{
Internal function to adapt generalized least squares (\code{gls}) model with more details in output.
}
\keyword{internal}
