% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_rch.R
\name{desc_rch}
\alias{desc_rch}
\title{Rechallenge descriptive}
\usage{
desc_rch(.data, demo_data, drug_s = "drug1", adr_s = "adr1")
}
\arguments{
\item{.data}{A \code{link} data.table. See \code{\link{link_}}.}

\item{demo_data}{A demo data.table.}

\item{drug_s}{A character string. The name of the drug column. Drug columns can be created with \code{\link{add_drug}}.}

\item{adr_s}{A character string. The name of the adr column. Adr columns can be created with \code{\link{add_adr}}.}
}
\value{
A data.table with one row per drug-adr pair
\itemize{
\item \code{drug_s} and \code{adr_s}, same as input.
\item Counts of \strong{overall}, \strong{rch}, \strong{inf}, and \strong{rec} cases (see details).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Computes counts of rechallenge cases,
over a set of adr and drug pairs.
}
\details{
Counts are provided at the \strong{case} level (not the drug-adr pair level).
Description span from number of rechallenge cases
to \strong{informative} rechallenge cases (those cases where the outcome is known).
You will need a \code{link} data.table, see \code{\link{link_}}, on which
you have added drugs and adrs with \code{\link[=add_drug]{add_drug()}} and \code{\link[=add_adr]{add_adr()}}.
Terminology
\itemize{
\item \code{Overall} as opposed to \code{rch} for rechallenged (\code{rch} + \code{no_rch} = \code{overall}).
\item Among \code{rch}, \code{inf} (informative) as opposed to \code{non_inf} (\code{inf} + \code{non_inf} = \code{rch})
\item Among \code{inf}, \code{rec} (recurring) as opposed to \code{non_rec} (\code{rec} + \code{non_rec} = \code{inf})
}
}
\examples{
link_ <-
  link_ |>
  add_drug(
    d_code = ex_$d_groups_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )

desc_rch(.data = link_,
         demo_data = demo_,
         drug_s = "pd1",
         adr_s = "a_colitis")

# You can vectorize over drugs and adrs

desc_rch(.data = link_,
         demo_data = demo_,
         adr_s = c("a_colitis", "a_pneumonitis"),
         drug_s = c("pd1", "pdl1")
         )
}
\seealso{
\code{\link{link_}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}, \code{\link[=desc_dch]{desc_dch()}}, \code{\link[=desc_tto]{desc_tto()}}
}
\keyword{descriptive}
\keyword{drug-adr-pair}
