% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_writer.R
\docType{class}
\name{data_writer}
\alias{data_writer}
\title{Data Writer}
\description{
A class responsible for the simulation data to disk.
}
\details{
This class can be subclasses to provide advanced data writing to other data sources. This should also
be subclassed if the winik and resource classes are subclasses, to write any addional fields to the data source.
}
\section{Methods}{

\describe{
\item{\code{write()}}{Writes the winik and resources to disk.}
}
Create a new data writer.
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{results_directory}}{The folder where the simulation resulst are written to}

\item{\code{winik_filename}}{The location where the winiks are written to}

\item{\code{resource_filename}}{The location where the resources are written to}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{data_writer$new()}}
\item \href{#method-write}{\code{data_writer$write()}}
\item \href{#method-clone}{\code{data_writer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new data writer object that has optional paths for data files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_writer$new(
  results_directory = "results",
  winik_filename = "winiks.csv",
  resource_filename = "resources.csv"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{results_directory}}{The directory where the results file is written to}

\item{\code{winik_filename}}{The name of the file for the winik data}

\item{\code{resource_filename}}{The name of the file for the resource data}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new winik object
Writes a village's state to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write"></a>}}
\if{latex}{\out{\hypertarget{method-write}{}}}
\subsection{Method \code{write()}}{
Takes a state an the name of a village and writes the winiks and resources to disk
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_writer$write(state, village_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The village's village_state that's being written}

\item{\code{village_name}}{The name of the village. This is used to create the data directory}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{data_writer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
