% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi.R
\name{vi}
\alias{vi}
\title{Variable Importance}
\usage{
vi(object, method = c("model", "pdp", "ice", "perm"), feature_names,
  FUN = NULL, truncate_feature_names = NULL, sort = TRUE,
  decreasing = TRUE, scale = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., a \code{"randomForest"} object).}

\item{method}{Character string specifying the type of variable importance
(VI) to compute. Current options are \code{"model"} (for model-based VI
scores), \code{"pdp"} (for PDP-based VI scores), \code{"ice"} (for ICE-based
VI scores), and \code{"perm"} (for permutation-based VI scores). The default
is \code{"model"}. For details on the PDP/ICE-based method, see the reference
below. Also, \code{method = "perm"} is currently ignored, but will be
available in a future release.}

\item{feature_names}{Character string giving the names of the predictor
variables (i.e., features) of interest.}

\item{FUN}{List with two componenets, \code{"cat"} and \code{"con"},
containing the functions to use for categorical and continuous features,
respectively. If \code{NULL}, the standard deviation is used for continuous
features. For categorical features, the range statistic is used (i.e.,
(max - min) / 4).}

\item{truncate_feature_names}{Integer specifying the length at which to
truncate feature names. Default is \code{NULL} which results in no truncation
(i.e., the full name of each feature will be printed).}

\item{sort}{Logical indicating whether or not to order the sort the variable
importance scores. Default is \code{TRUE}.}

\item{decreasing}{Logical indicating whether or not the variable importance
scores should be sorted in descending (\code{TRUE}) or ascending
(\code{FALSE}) order of importance. Default is \code{TRUE}.}

\item{scale}{Logical indicating whether or not to scale the variable
importance scores so that the largest is 100. Default is \code{FALSE}.}

\item{...}{Additional optional arguments.}
}
\value{
A tidy data frame (i.e., a \code{"tibble"} object) with two columns:
\code{Variable} and \code{Importance}. For \code{"glm"}-like object, an
additional column, called \code{Sign}, is also included which includes the
sign (i.e., POS/NEG) of the original coefficient.
}
\description{
Compute variable importance scores for the predictors in a model.
}
\examples{
#
# A projection pursuit regression example
#

# Load the sample data
data(mtcars)

# Fit a projection pursuit regression model
mtcars.ppr <- ppr(mpg ~ ., data = mtcars, nterms = 1)

# Compute variable importance scores
vi(mtcars.ppr, method = "ice")

# Plot variable importance scores
vip(mtcars.ppr, method = "ice")
}
\references{
Greenwell, B. M., Boehmke, B. C., and McCarthy, A. J. A Simple
and Effective Model-Based Variable Importance Measure. arXiv preprint
arXiv:1805.04755 (2018).
}
