% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vip.R
\name{vip}
\alias{vip}
\alias{vip.default}
\title{Variable Importance Plots}
\usage{
vip(object, ...)

\method{vip}{default}(object, num_features = 10L, bar = TRUE,
  width = 0.75, horizontal = TRUE, alpha = 1, color = "grey35",
  fill = "grey35", size = 1, shape = 19, all_permutations = FALSE,
  jitter = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., a \code{"randomForest"} object) or
an object that inherits from class \code{"vi"}.}

\item{...}{Additional optional arguments to be passed onto \code{\link{vi}}.}

\item{num_features}{Integer specifying the number of variable importance
scores to plot. Default is \code{10}.}

\item{bar}{Logical indicating whether or not to produce a barplot. Default
is \code{TRUE}. If \code{bar = FALSE}, then a dotchart is displayed instead.}

\item{width}{Numeric value specifying the width of the bars when
\code{bar = TRUE}. Default is \code{0.75}.}

\item{horizontal}{Logical indicating whether or not to plot the importance
scores on the x-axis (\code{TRUE}). Default is \code{TRUE}.}

\item{alpha}{Numeric value between 0 and 1 giving the transparency of the
bars (\code{bar = TRUE}) or points (\code{bar = FALSE}).}

\item{color}{Character string specifying the color to use for the borders of
the bars. Could also be a function, such as
\code{\link[grDevices]{heat.colors}}. Default is \code{"grey35"}.}

\item{fill}{Character string specifying the color to use to fill the bars.
Could also be a function, such as \code{\link[grDevices]{heat.colors}}.
Default is \code{"grey35"}.}

\item{size}{Numeric value indicating the size to use for the points whenever
\code{bar = FALSE}. Default is \code{1}.}

\item{shape}{Numeric value indicating the shape to use for the points
whenever \code{bar = FALSE}. Default is \code{1}.}

\item{all_permutations}{Logical indicating whether or not to plot all
permutation scores along with the average. Default is \code{FALSE}. (Only
used for permutation scores when \code{nsim > 1}.)}

\item{jitter}{Logical indicating whether or not to jitter the raw permutation
scores. Default is \code{FALSE}. (Only used when
\code{all_permutations = TRUE}.)}
}
\description{
Plot variable importance scores for the predictors in a model.
}
\examples{
#
# A projection pursuit regression example
#

# Load the sample data
data(mtcars)

# Fit a projection pursuit regression model
model <- ppr(mpg ~ ., data = mtcars, nterms = 1)

# Construct variable importance plot
vip(model, method = "ice")

# Better yet, store the variable importance scores and then plot
vi_scores <- vi(model, method = "ice")
vip(vi_scores, bar = FALSE, size = 3, horiz = FALSE)

# The \\code{\\link[magrittr]{\\\%T>\\\%}} operator is imported for convenience
vi_scores <- model \%>\%
  vi(method = "ice") \%T>\%
  {print(vip(.))}
vi_scores

# Permutation scores
vip(model, method = "permute", train = mtcars, target = "mpg", nsim = 10,
    metric = "rmse", bar = FALSE, color = "red", size = 3,
    all_permutations = TRUE, jitter = FALSE)
}
